# 更新日志

## **PAN271x DK v0.1.0**

PAN271x DK `v0.1.0` *(2025-10-17)* 已发布：

### 1. SDK

#### Build Tools 目录

- **JFlash**：精简版本的 JFlash 工具，用于 Keil 工程烧录。

#### Components 系统组件目录

- **PAN-USB**：Panchip USB 协议组件

#### Drivers 外设驱动目录

目前版本提供了如下外设驱动：

- ADC Driver
- CLK Driver
- ClkTrim Driver
- GPIO Driver
- I2C Driver
- KeyScan Driver
- LowPower Driver
- OTP Driver
- SPI Driver
- SYS Driver
- Timer Driver
- UART Driver
- WDT Driver

#### Platform 平台目录

存放 PAN271x 平台相关代码，包括芯片启动代码、平台初始化代码、Log 机制代码等。

#### Proprietary RF 私有 2.4G 目录

存放 PAN271x PRF 2.4G 相关代码，包括 2.4G Lib、2.4G API 接口等。

#### Samples 演示例程目录

目前版本提供了如下演示例程：

- **components/pan_usb_mouse**：PAN-USB HID Mouse 演示例程
- **drivers/adc**：ADC 驱动演示例程
- **drivers/clktrim**：ClkTrim 驱动演示例程
- **drivers/gpio**：GPIO 驱动演示例程
- **drivers/i2c**：I2C 驱动演示例程
- **drivers/kscan**：KeyScan 驱动演示例程
- **drivers/otp**：OTP 驱动演示例程
- **drivers/pwm**：PWM 驱动演示例程
- **drivers/spi**：SPI 驱动演示例程
- **drivers/timer**：Timer 驱动演示例程
- **drivers/uart**：UART 驱动演示例程
- **drivers/wdt**：WDT 驱动演示例程
- **miscellaneous/blinky**：EVB LED 演示例程
- **miscellaneous/coremark**：CoreMark 基准测试演示例程
- **miscellaneous/debug_proect**：SWD Debug Protect 演示例程
- **miscellaneous/low_power**：低功耗演示例程
- **miscellaneous/reset**：芯片 Reset 复位特性演示例程
- **proprietary_rf/prf_rx**：PRF 2.4G 接收演示例程
- **proprietary_rf/prf_tx**：PRF 2.4G 发送演示例程
- **solutions/prf_dongle**：2.4G Dongle 解决方案例程

### 2. HDK

目前版本提供了如下硬件相关资料：

- **PAN271x_BaseBoard_V1.0**：PAN271x EVB 底板硬件设计资料（原理图、PCB文件等）和生产资料（BOM、gerber、坐标等文件）
- **PAN271x_QFN28_CoreBoard_Std_V1.0**: PAN271x QFN28 核心板硬件设计资料（原理图、PCB文件等）和生产资料（BOM、gerber、坐标等文件）

### 3. DOC

目前版本提供了如下文档：

- SDK 快速入门指南
- SDK 开发环境搭建
- PAN107x EVB 硬件资源介绍
- PAN107x 硬件参考设计指南
- 19 个演示例程介绍
- 1 个解决方案介绍（2.4G Dongle）
- PRF 2.4G 开发指南
- 常见问题（FAQs）
- 量产烧录流程与工具介绍
- 射频测试流程与工具介绍
- Panchip ToolBox 工具箱介绍

### 4. TOOLS

目前版本提供了如下工具（材料）：
- PANLink 量产烧录工具（PC工具）
- Panchip ToolBox 工具箱工具（PC工具）
- RF 测试固件（芯片固件）
