/*******************************************************************************
 * @note      Copyright (C) 2019 Shanghai Panchip Microelectronics Co., Ltd.
 *            All rights reserved.
 * @file      main.c
 * @brief     Use FMC driver to performe flash operations and IAP feature.
 *            Flash operation include erasing, writting and reading
 *            IAP feature include running to LDROM without reset
 * @history - V1.0, 2019-3-20, lujiabo, first implementation.
*******************************************************************************/
#include "pan271x.h"
#include "lp_common.h"

/*---------------------------------------------------------------------------------------------------------*/
/* Define functions prototype                                                                              */
/*---------------------------------------------------------------------------------------------------------*/

void Clock_Init(void)
{
	PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_OTP_READ_MODE_SEL_Msk;
	PMU->SYS_CLK_CTRL &= ~(SYS_CLK_CTRL_OTP_CLK_HIGH_CYCLE_Msk | SYS_CLK_CTRL_OTP_CLK_LOW_CYCLE_Msk);
	PMU->SYS_CLK_CTRL |= ((0x1 << SYS_CLK_CTRL_OTP_CLK_HIGH_CYCLE_Pos) | (0x0 << SYS_CLK_CTRL_OTP_CLK_LOW_CYCLE_Pos));
	PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_OTP_SW_UP_CYCLE_EN_Msk;

	PMU->ANA_ANALDO |= ANA_ANALDO_EN_LDO_FSYN_AON_Msk;
    //MCU
	CLK_XthStartupConfig();
	PMU->XTH_CTRL |= XTH_CTRL_FSYNXO_BUFEN_AON_Msk;
    PMU->XTH_CTRL |= XTH_CTRL_FSYNXO_EN_AON_Msk;
	CLK_WaitClockReady(CLK_SYS_SRCSEL_XTH);

	CLK_HCLKConfig(0);

	CLK_SYSCLKConfig(CLK_DPLL_REF_CLKSEL_XTH,CLK_DPLL_OUT_48M); 
	CLK_RefClkSrcConfig(CLK_SYS_SRCSEL_DPLL_1);

	CLK_AHBPeriphClockCmd(CLK_AHBPeriph_All,ENABLE);
	CLK_APB1PeriphClockCmd(CLK_APB1Periph_All,ENABLE);
}

void Peri_Init(void)
{
    SYS_UnlockReg();

    /* Init I/O Multi-function  */
	SYS_SET_MFP(P0,6,UART0_RX);
	SYS_SET_MFP(P0,5,UART0_TX);
	GPIO_EnableDigitalPath(P0,BIT6);

	UART_Init(UART0, 115200);
	
    SYS_LockReg();
}

void Int_Enable(void)
{
	NVIC_EnableIRQ(LP_IRQn);
	NVIC_EnableIRQ(SLPTMR_IRQn);
	NVIC_EnableIRQ(SLPTMR1_IRQn);
	NVIC_EnableIRQ(TMR0_IRQn);
	NVIC_EnableIRQ(BOD_IRQn);
}

void platform_init()
{	
    Clock_Init();
    Peri_Init();
    Int_Enable();
}

/**
 * @brief      print sample project information
 * @param[in]  none
 * @return     none
 * @history  - V1.0, 2019-3-20, first implementation.
 */ 
//__attribute__((section("RAMCODE1"))) 
void LP_PrintSampleInfo()
{
    SYS_TEST("\n");
    SYS_TEST("+--------------------------------------------------------------------------+ \r\n");
    SYS_TEST("|                      PAN271x LowPower Sample Code.                       | \r\n");
    SYS_TEST("+--------------------------------------------------------------------------+ \r\n");
    SYS_TEST("|    press key to start test                                               | \r\n");
    SYS_TEST("|    Input'1'   LP_SleepModeTest();                                        | \r\n");
	SYS_TEST("|    Input'2'   LP_DeepSleepPwmOutTest();                                  | \r\n");
	SYS_TEST("|    Input'3'   LP_ContinuesSleepWakeByGpioClk32k();                       | \r\n");
    SYS_TEST("|    Input'4'   LP_StandbyModeTest();                                      | \r\n");
	SYS_TEST("|    Input'5'   LP_ContinuesStdbyWakeByGpio32k();                          | \r\n");
    SYS_TEST("+--------------------------------------------------------------------------+ \r\n");
}

int main(void)
{
    char cmd;

	#ifndef LP_DEBUG
	/*here set delay time prevent the soc unable to download after entering an abnormal state*/
//	SYS_delay_10nop(1000000);
	#endif
    platform_init();
	SYS_TEST("\nsram addr 0x20000B00,value=%08x \r\n",*((uint32_t*)(0x20000b00)));

    LP_PrintSampleInfo();

	cmd = getchar();
    while(cmd)
    {
        SYS_TEST("\r\n");
        switch(cmd)
        {
            case '1':    LP_TestFunctionEnter(0);break;
            case '2':    LP_TestFunctionEnter(1);break;
            case '3':    LP_TestFunctionEnter(2);break;
            case '4':    LP_TestFunctionEnter(3);break;
			case '5':    LP_TestFunctionEnter(4);break;
			default: break;
        }
        LP_PrintSampleInfo();
        cmd = getchar();
    }
    while(1);
}





