/*******************************************************************************
 * @note      Copyright (C) 2019 Shanghai Panchip Microelectronics Co., Ltd.
 *            All rights reserved.
 * @file      user_lp.c
 * @brief     Low Power test
 * @history - V1.0, 2019-3-21, zhangzhao, first implementation.
*******************************************************************************/
#include "pan271x.h"
#include "lp_common.h"


uint32_t LP_StandbyModeTest(void)
{
	char c,input;
	uint32_t tmp_reg;
    uint32_t wkupMode = LP_WKUP_MODE_SEL_GPIO;
	uint32_t stdbyMode = LP_STANDBY_M1_MODE1;
    uint32_t *sramData = (uint32_t*)(0x20000a00);
	char ldol[4], ldoh[4];

	SYS_TEST("Input 'A' mode1 selected\n");
	SYS_TEST("Input 'B' mode2 selected\n");
	char mode;
	mode = getchar();
	if ((mode == 'A') || (mode == 'a'))
		stdbyMode = LP_STANDBY_M1_MODE1;
	else
		stdbyMode = LP_STANDBY_M1_MODE2;
	SYS_delay_10nop(1000);
	uint32_t lpldo1;
	uint32_t lpldoh;
	SYS_TEST("Input lpldol trim\n");
	gets(ldol);
	lpldo1 = atoi(ldol);
	SYS_TEST("lpldol = %x\n", lpldo1);
	SYS_delay_10nop(1000);
	SYS_TEST("Input lpldoh trim\n");
	gets(ldoh);
	lpldoh = atoi(ldoh);
	SYS_TEST("lpldoh = %x\n", lpldoh);
	SYS_delay_10nop(1000);

	tmp_reg = PMU->ANA_LPLDO;
	tmp_reg &= ~ANA_LPLDO_PMU_LPLDOH_VSEL_AON_Msk;
	tmp_reg = (tmp_reg & ~(0xf << 20)) | (lpldoh << 20);
	PMU->ANA_LPLDO = tmp_reg;
	tmp_reg = PMU->ANA_RESERVED;
	tmp_reg &= ~ANA_RESERVED_PMU_LPLDOL_VSEL_AON_Msk;
	tmp_reg = (tmp_reg & ~(0xf<<17)) | (lpldo1 << 17);
	PMU->ANA_RESERVED = tmp_reg;

	SYS_TEST("  choose wake up mode	\r\n");
	SYS_TEST(" 'A': for 32k timer wake up \r\n");
	SYS_TEST(" 'B': for normal gpio wake up for standby m1/m0\r\n");
	SYS_TEST(" 'C': for wdt reset wake up for standby m1\r\n");
	SYS_TEST(" 'D': for BOD wake up for standby m1/m0\r\n");
	SYS_TEST(" 'E': for LVR wake up for standby m1/m0\r\n");
	c = getchar();
	
	/* close p03 reset function */
//	PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_PAD_RST_MASK_Msk;
	P0->MODE = 0;
	P1->MODE = 0;
	P2->MODE = 0;
	GPIO_DisableDigitalPath(P0,0xb7);
	GPIO_DisablePullupPath(P0,0xb7);
	GPIO_DisableDigitalPath(P1,0xff);
	GPIO_DisablePullupPath(P1,0xff);
	GPIO_DisableDigitalPath(P2,0x07);
	GPIO_DisablePullupPath(P2,0x07);


	GPIO_ClrAllIntFlag(P1);
	__NVIC_ClearPendingIRQ(GPIO1_IRQn);	
	GPIO_DisableInt(P1,2);
	
	LP_SetAnalogConfig(PMU, LP_CTRL0_CPU_LP_RET_EN_Msk, DISABLE);

	LP_SetOtpCeDelayTime(PMU, 0XA);
	LP_SetOtpPowerDelayTime(PMU, 0X2);

	switch(c)
	{
		case WK_BY_32K_TIMER_0:
        case WK_BY_32K_TIMER_1:
			SYS_TEST("\r\n  wake up by rcl 32k \r\n");
			SYS_delay_10nop(10000);
			wkupMode = LP_WKUP_MODE_SEL_32K;
			*sramData = 0x55aa1234;
			LP_SetSleepTimerConfig(PMU, SLPTMR_CTRL_SLPTMR_EN_Msk | SLPTMR_CTRL_SLPTMR_INT_EN_Msk
										| SLPTMR_CTRL_SLPTMR_CMP0_EN_Msk | SLPTMR_CTRL_SLPTMR_WK_EN_Msk,
										ENABLE);
			LP_SetUsrSleepTimer(32000 * 2, 0);
			GPIO_DisableDigitalPath(P0,BIT6);
			LP_SetStandbyMode1Config(PMU, wkupMode, stdbyMode);
			break;

			
		case WK_BY_GPIO_0:
		case WK_BY_GPIO_1:
			SYS_TEST(" wake up by normal gpio \r\n");
            SYS_delay_10nop(1000);
			SYS_SET_MFP(P1, 2, GPIO);
			GPIO_SetMode(P1,BIT2,GPIO_MODE_INPUT);
			GPIO_EnableDigitalPath(P1,BIT2);
			GPIO_EnablePulldownPath(P1,BIT2);
			GPIO_EnableInt(P1,2,GPIO_INT_HIGH);
			GPIO_ClrAllIntFlag(P1);
			#ifdef FPGA_MODE
			SYS_delay_10nop(1000);
			#endif
			__NVIC_ClearPendingIRQ(GPIO1_IRQn);
			NVIC_EnableIRQ(GPIO1_IRQn);
			wkupMode = LP_WKUP_MODE_SEL_GPIO;
			*sramData = 0x12345678;
			SYS_TEST("  choose standby mode	\r\n");
			SYS_TEST(" 'A': standby m0	\r\n");
			SYS_TEST(" 'B': standby m1 \r\n");
			input = getchar();
			GPIO_DisableDigitalPath(P0,BIT6);
			if (input == 'a' || input == 'A')
				LP_SetStandbyMode0Config(wkupMode);
			else
				LP_SetStandbyMode1Config(PMU, wkupMode, stdbyMode);
			break;

			
		case WK_BY_WDT_0:
		case WK_BY_WDT_1:
			SYS_TEST("\r\nwake up by watchdog \r\n");
			SYS_delay_10nop(10000);
			*sramData = 0x12345678;
			SYS_UnlockReg();
			NVIC_EnableIRQ(WDT_IRQn);
			WDT_Open(WDT_TIMEOUT_2POW14, WDT_RESET_DELAY_1025CLK, TRUE, TRUE);
			WDT_EnableInt();
			wkupMode = LP_WKUP_MODE_SEL_WDT;
			GPIO_DisableDigitalPath(P0,BIT6);
			LP_SetStandbyMode1Config(PMU, wkupMode, stdbyMode);
			break;	
			
		case WK_BY_BOD_0:
		case WK_BY_BOD_1:
			SYS_TEST("\r\nwake up by bod \r\n");
			SYS_delay_10nop(10000);
			*sramData = 0x12345678;
			SYS_TEST("flga:%x\n", PMU->LP_FLAG_CTRL);
			SYS_delay_10nop(10000);
			CLK_ConfigureBOD(CLK_BODCTL_BOD_INT_EN, CLK_BODCTL_BODSEL_2_75V);
			NVIC_EnableIRQ(BOD_IRQn);
			wkupMode = LP_WKUP_MODE_SEL_BOD;
			SYS_TEST("  choose standby mode	\r\n");
			SYS_TEST(" 'A': standby m0	\r\n");
			SYS_TEST(" 'B': standby m1 \r\n");
			input = getchar();
			SYS_delay_10nop(10000);
			GPIO_DisableDigitalPath(P0,BIT6);
			if (input == 'a' || input == 'A')
				LP_SetStandbyMode0Config(wkupMode);
			else
				LP_SetStandbyMode1Config(PMU, wkupMode, stdbyMode);
			break;
		case WK_BY_LVR_0:
		case WK_BY_LVR_1:
			SYS_TEST("\r\nwake up by lvr \r\n");
			SYS_delay_10nop(10000);
			*sramData = 0x12345678;
			SYS_delay_10nop(10000);
			CLK_EnableLVR();
			wkupMode = LP_WKUP_MODE_SEL_LVR;
			SYS_TEST("  choose standby mode	\r\n");
			SYS_TEST(" 'A': standby m0	\r\n");
			SYS_TEST(" 'B': standby m1 \r\n");
			input = getchar();
			SYS_delay_10nop(10000);
			GPIO_DisableDigitalPath(P0,BIT6);
			if (input == 'a' || input == 'A')
				LP_SetStandbyMode0Config(wkupMode);
			else
				LP_SetStandbyMode1Config(PMU, wkupMode, stdbyMode);
			break;
		default:
			break;
	}

	return 0;
}
