/*******************************************************************************
 * @note      Copyright (C) 2019 Shanghai Panchip Microelectronics Co., Ltd.
 *            All rights reserved.
 * @file      user_lp.c
 * @brief     Low Power test
 * @history - V1.0, 2019-3-21, zhangzhao, first implementation.
*******************************************************************************/
#include "pan271x.h"
#include "lp_common.h"


uint32_t LP_SleepModeTest(void)
{
	char c;

	while(true){
		SYS_TEST("\r\n");
		SYS_TEST("Choose wake up mode:					\r\n");
		SYS_TEST(" 'A'  for sleep timer wake up 			\r\n");
		SYS_TEST(" 'B'  for gpio wake up 				\r\n");
		SYS_TEST(" 'C'  for wdt wake up 			    \r\n");
		c = getchar();
		
		switch(c)
		{
			case WK_BY_32K_TIMER_0:
			case WK_BY_32K_TIMER_1:
				SYS_TEST("\r\nwake up by rcl 32k \r\n");
				LP_SetAnalogConfig(PMU, LP_CTRL0_SLOW_CLK_LP_CTRL_Msk, ENABLE);
				LP_SetSleepTimerConfig(PMU, SLPTMR_CTRL_SLPTMR_EN_Msk | SLPTMR_CTRL_SLPTMR_INT_EN_Msk
										| SLPTMR_CTRL_SLPTMR_CMP0_EN_Msk | SLPTMR_CTRL_SLPTMR_WK_EN_Msk,
										ENABLE);
				LP_SetUsrSleepTimer(32000 * 2, 0);
				break;
			case WK_BY_GPIO_0:
			case WK_BY_GPIO_1:
				SYS_TEST("\r\nwake up by gpio P12 \r\n");
				SYS_SET_MFP(P1, 2, GPIO);
				GPIO_SetDebounceTime(GPIO_DBCTL_DBCLKSRC_RCL, GPIO_DBCTL_DBCLKSEL_1);
				GPIO_SetMode(P1,BIT2,GPIO_MODE_INPUT);
				GPIO_EnableDigitalPath(P1,BIT2);
				GPIO_EnablePulldownPath(P1,BIT2);
				GPIO_EnableInt(P1,2,GPIO_INT_RISING);
				GPIO_ClrAllIntFlag(P1);
				#ifdef FPGA_MODE
				SYS_delay_10nop(1000);
				#endif
				__NVIC_ClearPendingIRQ(GPIO1_IRQn);
				NVIC_EnableIRQ(GPIO1_IRQn);
				break;		
			case WK_BY_WDT_0:
			case WK_BY_WDT_1:
				SYS_TEST("\r\nwake up by watchdog \r\n");
				SYS_UnlockReg();
				NVIC_EnableIRQ(WDT_IRQn);
				WDT_Open(WDT_TIMEOUT_2POW14, WDT_RESET_DELAY_2CLK, FALSE, TRUE);
				WDT_EnableInt();
				break;
			case 0x1b:
				goto OUT;
			default:
				break;
		}
		GPIO_DisableDigitalPath(P0,BIT6);
		LP_SetSleepModeConfig(PMU,0);

		SYS_TEST("sleep mode run continue \r\n");
		GPIO_EnableDigitalPath(P0,BIT6);
	}
OUT:
    return 0;
}

