/**************************************************************************//**
 * @file     uart_fifo_and_threshold_test.c
 * @version  V1.0
 * $Date:    19/10/08 11:30 $
 * @brief    UART test case 4, test FIFO threshold of UART.
 *
 * @note
 * Copyright (C) 2019 Panchip Technology Corp. All rights reserved.
 *
 ******************************************************************************/
#include "pan271x.h"
#include "uart_common.h"


static const uint8_t Const8BitData[] = 
{
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
    0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C,
};

static void UART_PrintTxTriggerLevel(void)
{
    SYS_TEST("\n");
    SYS_TEST("+-----------------------------------------------------------------+ \n");
    SYS_TEST("|    Press key to select tx trig level:                           | \n");
    SYS_TEST("|                                                                 | \n");
    SYS_TEST("|    Input '0'    Trigger Tx: FIFO empty                          | \n");
    SYS_TEST("|    Input '1'    Trigger Tx: FIFO 2 char                         | \n");
    SYS_TEST("|    Input '2'    Trigger Tx: FIFO 3 char                         | \n");
    SYS_TEST("|    Input '3'    Trigger Tx: FIFO 4 char                         | \n");
    SYS_TEST("+-----------------------------------------------------------------+ \n");
}

static void UART_PrintRxTriggerLevel(void)
{
    SYS_TEST("\n");
    SYS_TEST("+-----------------------------------------------------------------+ \n");
    SYS_TEST("|    Press key to select rx trig level:                           | \n");
    SYS_TEST("|                                                                 | \n");
    SYS_TEST("|    Input '0'    Trigger Rx: FIFO 1 char                         | \n");
    SYS_TEST("|    Input '1'    Trigger Rx: FIFO 2 char                         | \n");
    SYS_TEST("|    Input '2'    Trigger Rx: FIFO 3 char                         | \n");
    SYS_TEST("|    Input '3'    Trigger Rx: FIFO 4 char                         | \n");
    SYS_TEST("+-----------------------------------------------------------------+ \n");
}

static void MultiDataSendReceiveTest(void)
{
	uint8_t level = UART_GetRxFifoLevel(TGT_UART)+1;

    // Copy data to send to tx buffer
    memcpy((void*)uartTxBuffer, Const8BitData, sizeof(Const8BitData));
    uartTxBufIdx = sizeof(Const8BitData);

    // Enable Interrupts
    UART_EnableIrq(TGT_UART, UART_IRQ_TX_NOT_FULL);   //Enable THRE Interrupt
    UART_EnableIrq(TGT_UART, UART_IRQ_RX_NOT_EMPTY);   //Enable RDA Interrupt
	UART_EnableIrq(TGT_UART, UART_IRQ_RX_TIMEOUT);   //Enable RDA Interrupt

    SYS_TEST("FIFO trigger level setting done, prepare to transmit data (%d Bytes)...\n", uartTxBufIdx);
	uartRxBufIdx = 0;
    NVIC_EnableIRQ(TGT_UART_IRQn);              //Enable target UART INT in NVIC

    // Prepare to print buffer data out once detected first data entry in Rx FIFO
	while(uartRxBufIdx < rxRcvNum) {}

	SYS_TEST("Begin to receive data...\n");

    // Print out all received data
    SYS_TEST("Data received (length=%d):", uartRxBufIdx);
    for (size_t i = 0; i < uartRxBufIdx; i++)
    {
        if (i % 8 == 0)
            SYS_TEST("\n");
        SYS_TEST(" 0x%02x", uartRxBuffer[i]);
    }
    SYS_TEST("\n");
    uartRxBufIdx = 0;   //Reset Rx buf index

    // Disable interrupts after use
    NVIC_DisableIRQ(TGT_UART_IRQn);
    UART_DisableIrq(TGT_UART, UART_IRQ_TX_NOT_FULL);
    UART_DisableIrq(TGT_UART, UART_IRQ_RX_NOT_EMPTY);
}

T_UART_TEST_RESULT UART_InterruptTestCase2(void)
{
    char c;
	uint8_t trig = 0;
	uint32_t baud_rate;

	UART_DisableRx(TGT_UART);
	UART_DisableTx(TGT_UART);
    baud_rate = 115200;
    UART_Init(TGT_UART, baud_rate);

	UART_PrintRxTriggerLevel();
	c = getchar();
	trig = c - '0';
	UART_SetRxIntTrigger(TGT_UART, (UART_RxTriggerDef)trig);

	UART_PrintTxTriggerLevel();
	c = getchar();
	trig = c - '0';
	UART_SetTxIntTrigger(TGT_UART, (UART_TxTriggerDef)trig);
	
	UART_EnableRxTimeout(TGT_UART);
	UART_SetRxTimeoutCnt(TGT_UART, 32000);
	
	MultiDataSendReceiveTest();

    return UART_TST_OK;
}
