/**************************************************************************//**
 * @file     timer_wakeup_test.c
 * @version  V1.0
 * $Date:    19/11/02 15:50 $
 * @brief    Timer test case 4, test wakeup from low power mode.
 * @note
 * Copyright (C) 2019 Panchip Technology Corp. All rights reserved.
 *
 ******************************************************************************/
#include "PanSeries.h"
#include "timer_common.h"

extern const bool PanFlashEnhanceEnable;

static void TIMER_PrintInfoCase4(void)
{
    SYS_TEST("\n");
    SYS_TEST("+-----------------------------------------------------------------+ \n");
    SYS_TEST("|    Press key to test specific function:                         | \n");
    SYS_TEST("|                                                                 | \n");
    SYS_TEST("|    Input 'A'    Wakeup from power down mode.                    | \n");
    SYS_TEST("|    Press ESC key to back to the top level case list.            | \n");
    SYS_TEST("+-----------------------------------------------------------------+ \n");
}

static void TIMER_WakeupFromPowerDownModeProc(void)
{
	SYS_TEST("to do\n");
}

T_TIMER_TEST_RESULT TIMER_WakeupTestCase4(void)
{
    char c;
	
	TIMER0->TIMER_CTL |= TIMER_CTL_WK_EN_Msk;
    while(1)
    {
        TIMER_PrintInfoCase4();
        switch(c = getchar())
        {
        /* A. Wakeup from power down mode */
        case 'A':
        case 'a':
            TIMER_WakeupFromPowerDownModeProc();
            break;
        case 0x1B:  // Keyboard code <ESC>
            goto OUT;
        default:
            SYS_WARN("Cannot find subtest case %c!\n", c);
            break;
        }
    }
OUT:
    return TIMER_TST_OK;
}
