/**************************************************************************//**
 * @file     timer_common.h
 * @version  V1.0
 * $Date:    19/10/30 16:47 $
 * @brief    Common header file for Timer test.
 *
 * @note
 * Copyright (C) 2019 Panchip Technology Corp. All rights reserved.
 *
 ******************************************************************************/
#ifndef __TIMER_COMMON_H__
#define __TIMER_COMMON_H__

#include <stdint.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C"
{
#endif

typedef enum _T_TIMER_TST_RESULT
{
    TIMER_TST_OK,
} T_TIMER_TEST_RESULT;


// Config UART for Debug/Log
#define DEBUG_PORT      UART0   //Note this define should be same with that in retarget.c


#define TGT_TIMER           TIMER0
#define TGT_TIMER_CLK_APB   CLK_APB1_TMR0SEL_APB1CLK
#define TGT_TIMER_CLK_RCL   CLK_APB1_TMR0SEL_RCL32K
#define TGT_TMR_IRQn        TMR0_IRQn


// Test Case Functions
extern T_TIMER_TEST_RESULT TIMER_TimerCountingModesTestCase(void);

extern void TIMER_TestModuleInit(void);
extern void TIMER_DelayMs(TIMER_T *timer, uint32_t u32Ms);

extern volatile uint32_t tmr_int_trigger_cnt;
extern volatile uint32_t tmr_cap_int_cnt;
extern volatile uint32_t cap_buf[20];

#ifdef __cplusplus
}
#endif

#endif //__TIMER_COMMON_H__
