/**************************************************************************//**
 * @file     spi_common.h
 * @version  V1.0
 * $Date:    19/10/22 14:34 $
 * @brief    Common header file for SPI test.
 *
 * @note
 * Copyright (C) 2019 Panchip Technology Corp. All rights reserved.
 *
 ******************************************************************************/
#ifndef __SPI_COMMON_H__
#define __SPI_COMMON_H__

#include <stdint.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C"
{
#endif

#define __ramfunc __attribute__((section(".ramcode")))

#define CHAR_NONE       (-1)

typedef enum _T_SPI_TST_RESULT
{
    SPI_TST_OK,
} T_SPI_TEST_RESULT;

// Config SPI software buffer size
#define SPI_RX_BUF_SIZE         256
#define SPI_TX_BUF_SIZE         256

// Config UART for Debug/Log
#define DEBUG_PORT      UART0   //Note this define should be same with that in retarget.c

// Config Target SPI for Test
#define TGT_SPI_ID      TEST_SPI0


#define TEST_SPI0       0
#define TEST_SPI1       1

#define TGT_SPI             SPI0
#define TGT_SPI_IRQn        SPI0_IRQn
#define TGT_SPI_DMA_SRC     DMAC_Peripheral_SPI0_Rx
#define TGT_SPI_DMA_DST     DMAC_Peripheral_SPI0_Tx


// Test Case Functions
extern T_SPI_TEST_RESULT SPI_InterruptTestCase(void);
extern T_SPI_TEST_RESULT SPI_SimpleTransmissionDemoCase(void);

extern void SPI_TestFunctionEnter(uint16_t TcIdx);
extern void SPI_TestModuleInit(void);

extern size_t SPI_RecvMultiDataAsync(SPI_T* SPIx, uint8_t* data, size_t expect_recv_size);
extern size_t SPI_SendMultiDataAsync(SPI_T* SPIx, const uint8_t* data, size_t expect_send_size);
extern void SPI_MultiDataSendReceiveAsync(SPI_T* SPIx, const uint8_t* data_to_send, size_t expect_send_size, uint8_t* buf_to_recv, size_t expect_recv_size);
extern void SPI_RecvMultiDataSync(SPI_T* SPIx, uint8_t* data, size_t expect_recv_size);
extern void SPI_SendMultiDataSync(SPI_T* SPIx, const uint8_t* data, size_t expect_send_size);


extern uint8_t spiRxBuffer[SPI_RX_BUF_SIZE];
extern uint8_t spiTxBuffer[SPI_TX_BUF_SIZE];

extern volatile uint32_t spiRxBufIdx;
extern uint32_t spiTxBufIdx;
extern volatile bool spiTxDone;

#ifdef __cplusplus
}
#endif

#endif //__SPI_COMMON_H__
