/********************************************************* * 
@file		:spi_common.c 
@brief  	:common interface source file,store some common interface functions 
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/10/31
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/
#include "pan271x.h"
#include "otp_common.h"

void data_printf(uint8_t const *data, uint32_t len)
{
	uint32_t i = 0;

	if (len == 0) 
	{
		return;
	}

	for (i = 0; i < len; i++) 
	{
		SYS_TEST("0x%02X ", data[i]);
	}
	SYS_TEST("\n");
}

__ramfunc void ReadColumn(uint32_t Addr, uint8_t *buf)
{
	uint32_t read_value = 0, adr = Addr;
	uint8_t cnt = 0;

	adr = (adr << 9);
	for (cnt = 0; cnt < 8; cnt++) {
		OTP->BYTE_ADDR = adr;
		OTP->OPERATE_TRG |= 0X1;
		while(OTP->OPERATE_TRG) {}
		read_value = OTP->OPERATE_DATA_0;
		if (cnt == 0)
			*buf = (read_value & 0x1);
		else
			*buf |= ((read_value & 0x1) << cnt);
		adr += 0x40;
	}
}

__ramfunc void WriteColumn(uint32_t Addr, uint8_t *buf)
{
	uint32_t adr = Addr;
	uint8_t w_data, cnt = 0;

	adr = (adr << 9);
	for (cnt = 0; cnt < 8; cnt++) {
		OTP->BYTE_ADDR = adr;
		w_data = ((*buf >> cnt) & 0x1);
		OTP->OPERATE_DATA_0 = w_data;
		OTP->OPERATE_TRG |= 0X1;
		while(OTP->OPERATE_TRG) {}
		adr += 0x40;
	}
}


__ramfunc void TempFunc_SetTrTrim(uint16_t trim)
{
	uint16_t cnt = 0;

	PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_OTP_WR_EN_Msk;
	PMU->SYS_CLK_CTRL = (PMU->SYS_CLK_CTRL & ~SYS_CLK_CTRL_OTP_TR_TRIM_Msk) | (trim << SYS_CLK_CTRL_OTP_TR_TRIM_Pos);
	PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_OTP_SW_UP_TR_EN_Msk;
	for(cnt = 0; cnt < 1000; cnt++){
		;
	}
}
