/********************************************************* * 
@file		:ks_default_value.c 
@brief  	:keyscan register default value check
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/10/28
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/

#include "pan271x.h"
#include "ks_common.h"

const uint32_t KsDefaultValue[]=
{
    0x0,                    //KS_EN      ,0x00
    0x0,                    //KS_IO_CFG  ,0x04
    0x0,                    //KS_INT_CFG ,0X08
    0x804,                  //KS_CFG     ,0X0C
    0x0,                    //KS_INFO0   ,0X10
    0x0,                    //KS_INFO1   ,0X14
};

/*
  * @brief	   :keyscan register default value check
  * @retval    :0/1
*/
uint32_t KS_RegisterDefaultCheckCase1(void)
{
    uint8_t i = 0,different = 0;

    for(i=0;i<sizeof(KsDefaultValue)/sizeof(uint32_t);i++){
        if(KsDefaultValue[i]!=((uint32_t*)&KSCAN->KS_EN)[i]){
            SYS_TEST("offset:%x,respect:%x,current:%x \r\n",i*4,KsDefaultValue[i],((uint32_t*)&KSCAN->KS_EN)[i]); 
            different++;
        }
    }  
    if(!different){
       SYS_TEST("keyscan default value check ok \r\n"); 
    }
    return 0;
}

