/********************************************************* * 
@file       :ks_int_test.c 
@brief      :keyscan interrupt function test
@author     :zhongfeng
@version    :v1.0 
@date       :19/10/28
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/
#include "pan271x.h"
#include "ks_common.h"


uint32_t KS_DebounceTestCase6(void)
{
    uint32_t keyscanDiv = 2;

    NVIC_EnableIRQ(KSCAN_IRQn);

	CLK_SetKeyscanClkSrc(CLKTRIM_KSCAN_CLK_SEL_32K);
	CLK_SetKeyscanDiv(keyscanDiv);
	KS_SetFrameInterval(KSCAN,KS_INTERVAL_TIME_CLK_4);
//	KS_SetRowInterval(KSCAN,KS_INTERVAL_TIME_CLK_16);
	KS_SetDebounceTime(KSCAN,KS_INTERVAL_TIME_CLK_8K);
	
    KS_IntEnable(KSCAN,ENABLE);
    KS_Enable(KSCAN,ENABLE,KS_PERIPHRAL_ENABLE);

    while(1) {
        char c = getchar();
        if(c == 0x1b)
            break;
    }
    return 0;
}
