/********************************************************* * 
@file       :ks_common.c 
@brief      :common interface source file,store some common interface functions 
@author     :zhongfeng
@version    :v1.0 
@date       :19/08/29
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/
#include "pan271x.h"
#include "ks_common.h"

bool wk_by_kscan_flag = FALSE;

uint32_t (*KS_TestEntry[])(void) =
{
    KS_IntTestCase,
    KS_PollingTestCase,
};

void KS_TestFunctionEnter(uint16_t Idx)
{
    (KS_TestEntry[Idx])();
}

void KS_TestModuleInit(void)
{
    //set input iomux
    SYS_SET_MFP(P2, 0, KS_I2);
    GPIO_EnableDigitalPath(P2, BIT0);
    KS_InputEnable(KSCAN, ENABLE, 0x04);

    //set output iomux
    SYS_SET_MFP(P0, 2, KS_O1);
    SYS_SET_MFP(P1, 2, KS_O2);
    SYS_SET_MFP(P1, 4, KS_O4);
    KS_OutputEnable(KSCAN, ENABLE, ((0x3 << 1) | (0x1 << 4)));

#if 1//def ENABLE_INTERNAL_PULLUP_RES
    GPIO_EnablePullupPath(P2, BIT0);
#endif // ENABLE_INTERNAL_PULLUP_RES

}

const uint8_t row[3] = {1,2,4};
const uint8_t col[1] = {2};

void KSCAN_IRQHandler(void)
{
    uint8_t i,j;
    SYS_TEST("IRQ\n");
    if(KS_StatusCheck(KSCAN,KS_INT_FLAG_Msk)){
        SYS_TEST("key ");
        for(i=0;i<sizeof(row);i++){
            for(j=0;j<sizeof(col);j++){
                if(KS_IsKeyPressed(KSCAN,row[i],col[j])){
                    SYS_TEST("%d_%d ",i,j);
                }
            }
        }
        SYS_TEST("pressed\n");
        KS_ClearFlag(KSCAN,KS_INT_FLAG_Msk);
        KS_Enable(KSCAN,ENABLE,KS_PERIPHRAL_ENABLE);
    }
}
