/********************************************************* * 
@file		:i2c_status_check.c 
@brief  	:i2c status check case
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/10/16
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/

#include "pan271x.h"
#include "i2c_common.h"

uint8_t I2C_WriteWithoutUsrAddr(uint8_t *buf, uint8_t length)
{
    uint8_t i;
    uint8_t ret;

    ret = I2C_Start();
    if (ret != TRUE)
    {
        goto exit;
    }

	/* send error addr */
    ret = I2C_SendDevAddr(0x70, I2C_WRITE);
    if (ret != TRUE)
    {
		SYS_TEST("addr send error\n");
		I2C_Stop();
    }


    ret = I2C_Start();
    if (ret != TRUE)
    {
		SYS_TEST("start error\n");
        goto exit;
    }

    ret = I2C_SendDevAddr(I2C_MASTER_TAR_ADDRESS7, I2C_WRITE);
    if (ret != TRUE)
    {
		SYS_TEST("addr send error\n");
        goto exit;
    }

    for (i = 0; i < length; i++)
    {
        ret = I2C_WriteByte(buf[i]);
        if (ret != TRUE)
        {
			SYS_TEST("write data error\n");
            goto exit;
        }
    }

exit:
    I2C_Stop(); // Send stop signal
    return ret;
}

uint8_t I2C_Write(uint16_t mem_addr, uint8_t addr_size, uint8_t *buf, uint8_t length)
{
    uint8_t i;
    uint8_t ret;

    ret = I2C_Start();
    if (ret != TRUE)
    {
		SYS_TEST("start error\n");
        goto exit;
    }

    ret = I2C_SendDevAddr(I2C_MASTER_TAR_ADDRESS7, I2C_WRITE);
    if (ret != TRUE)
    {
		SYS_TEST("addr send error\n");
        goto exit;
    }

    if (addr_size == 2)
    {
        ret = I2C_WriteByte(mem_addr >> 8);
        if (ret != TRUE)
        {
            goto exit;
        }
    }

    ret = I2C_WriteByte(mem_addr);
    if (ret != TRUE)
    {
        goto exit;
    }

    for (i = 0; i < length; i++)
    {
        ret = I2C_WriteByte(buf[i]);
        if (ret != TRUE)
        {
			SYS_TEST("write data error\n");
            goto exit;
        }
    }

exit:
    I2C_Stop(); // Send stop signal
    return ret;
}


uint32_t I2C_CheckStatusCase(void)
{
    uint8_t WriteBuf[__BYTE_LEN+1] = {0};

	SYS_TEST("I2C_MasterSendDataCase \r\n");
	I2C_DeInit();
    I2C_Init(I2C_DIV_60);

    FillBuffer(WriteBuf,__BYTE_LEN);
	I2C_WriteWithoutUsrAddr(WriteBuf, __BYTE_LEN);
    return 0;
}

