/********************************************************* * 
@file		:i2c_master_receive_data.c 
@brief  	:i2c master receive data from slave
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/10/16
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/

#include "pan271x.h"
#include "i2c_common.h"

/* read func:  r_data*/
uint8_t IIC_ReadMem(uint8_t *buf, uint8_t length)
{
    uint8_t i;
    uint8_t ret;
    
    ret = I2C_Start();
    if (ret != TRUE) {
		SYS_TEST("start error\n");
        goto exit;
    }

    if (length == 1) {
        I2C_DisableAck();
    } else {
        I2C_EnableAck();
    }

    ret = I2C_SendDevAddr(I2C_MASTER_TAR_ADDRESS7|0x1, I2C_READ);
    if (ret != TRUE) {
		SYS_TEST("addr error\n");
        goto exit;
    }

    if (length >= 2) {
        for (i = 0; i < length - 1; i++) {
            if (i == (length - 2)) {
                I2C_DisableAck(); // After next read, response nack
            }
            else {
                I2C_EnableAck(); // After next read, response ack
            }

            ret = I2C_ReadByte(&buf[i], I2C_TYPE_ACK);
            if (ret != TRUE) {
				SYS_TEST("read data error\n");
                goto exit;
            }
        }

        ret = I2C_ReadByte(&buf[length - 1], I2C_TYPE_NACK);
        if (ret != TRUE) {
			SYS_TEST("read last data error\n");
            goto exit;
        }
    } else {
        ret = I2C_ReadByte(&buf[length - 1], I2C_TYPE_NACK);
        if (ret != TRUE) {
			SYS_TEST("read one data error\n");
            goto exit;
        }
    }

exit:
    I2C_Stop();
    return ret;
}

/* read func1:  w_addr + r_data*/
uint8_t I2C_Read(uint16_t mem_addr, uint8_t addr_size, uint8_t *buf, uint8_t length)
{
    uint8_t i;
    uint8_t ret;
    
    ret = I2C_Start();
    if (ret != TRUE) {
        goto exit;
    }

    ret = I2C_SendDevAddr(I2C_MASTER_TAR_ADDRESS7, I2C_WRITE);
    if (ret != TRUE) {
        goto exit;
    }

    if(addr_size == 2)
    {
        ret = I2C_WriteByte(mem_addr>>8);
        if (ret != TRUE)
        {
            goto exit;
        }
    }

    ret = I2C_WriteByte(mem_addr);
    if (ret != TRUE)
    {
        goto exit;
    }
	
    //Send restart signal
    ret = I2C_Restart();
    if (ret != TRUE) {
        goto exit;
    }

    if (length == 1) {
        I2C_DisableAck();
    } else {
        I2C_EnableAck();
    }

    ret = I2C_SendDevAddr(I2C_MASTER_TAR_ADDRESS7|0x1, I2C_READ);
    if (ret != TRUE) {
        goto exit;
    }

    if (length >= 2) {
        for (i = 0; i < length - 1; i++) {
            if (i == (length - 2)) {
                I2C_DisableAck(); // After next read, response nack
            }
            else {
                I2C_EnableAck(); // After next read, response ack
            }
		
            ret = I2C_ReadByte(&buf[i], I2C_TYPE_ACK);
            if (ret != TRUE) {
                goto exit;
            }
        }

        ret = I2C_ReadByte(&buf[length - 1], I2C_TYPE_NACK);
        if (ret != TRUE) {
            goto exit;
        }
    } else {
        ret = I2C_ReadByte(&buf[length - 1], I2C_TYPE_NACK);
        if (ret != TRUE) {
            goto exit;
        }
    }

exit:
    I2C_Stop();
    return ret;
}



uint32_t I2C_MasterReceiveDataCase(void)
{
    uint8_t ReadBuf[__BYTE_LEN+1] = {0};

	SYS_TEST("I2C_MasterReceiveDataCase \r\n");
	I2C_DeInit();
    I2C_Init(I2C_DIV_60);

	IIC_ReadMem(ReadBuf, __BYTE_LEN);
	SYS_TEST("RCV DATA: ");
	for (uint16_t i = 0; i < __BYTE_LEN; i++) {
		SYS_TEST("%x ", ReadBuf[i]);
	}
	SYS_TEST("\n");
    return 0;
}

