/**************************************************************************//**
 * @file     clktrim_measure.c
 * @version  V1.0
 * $Date:    20/10/14 16:42 $
 * @brief    Common source file for clktrim test.
 *
 * @note
 * Copyright (C) 2020 Panchip Technology Corp. All rights reserved.
 *
 ******************************************************************************/
#include <ctype.h>
#include "pan271x.h"
#include "clktrim_common.h"

static void PrintSampleNumber(void)
{
	SYS_TEST("\n");
    SYS_TEST("+--------------------------------------------------------------------------------------+ \n");
    SYS_TEST("|                      PAN271 Clk measure sample number select.                        | \n");
    SYS_TEST("+--------------------------------------------------------------------------------------+ \n");
	SYS_TEST("|    Press key to select sample number:                                                | \n");
	SYS_TEST("|    Input '0'    Sample number select 1.                                              | \n");
	SYS_TEST("|    Input '1'    Sample number select 2.                                              | \n");
	SYS_TEST("|    Input '2'    Sample number select 4.                                              | \n");
	SYS_TEST("|    Input '3'    Sample number select 8.                                              | \n");
	SYS_TEST("|    Input '4'    Sample number select 16.                                             | \n");
	SYS_TEST("|    Input '5'    Sample number select 32.                                             | \n");
	SYS_TEST("|    Input '6'    Sample number select 64.                                             | \n");
	SYS_TEST("|    Input '7'    Sample number select 128.                                            | \n");
	SYS_TEST("+--------------------------------------------------------------------------------------+ \n");
}


static void PrintEdgeMode(void)
{
	SYS_TEST("\n");
    SYS_TEST("+--------------------------------------------------------------------------------------+ \n");
    SYS_TEST("|                      PAN271 Clk measure edge mode select.                            | \n");
    SYS_TEST("+--------------------------------------------------------------------------------------+ \n");
	SYS_TEST("|    Press key to select edge mode:                                                    | \n");
	SYS_TEST("|    Input '0'    Edge mode select rising.                                             | \n");
	SYS_TEST("|    Input '1'    Edge mode select failing.                                            | \n");
	SYS_TEST("|    Input '2'    Edge mode select high voltage(only one time sample).                 | \n");
	SYS_TEST("|    Input '3'    Edge mode select low voltage(only one time sample).                  | \n");
	SYS_TEST("+--------------------------------------------------------------------------------------+ \n");
}

static void PrintClkSourceToBeTested(void)
{
	SYS_TEST("\n");
    SYS_TEST("+--------------------------------------------------------------------------------------+ \n");
    SYS_TEST("|                      PAN271 Clk source to be tested.                                 | \n");
    SYS_TEST("+--------------------------------------------------------------------------------------+ \n");
	SYS_TEST("|    Press key to select clk source to be tested:                                      | \n");
	SYS_TEST("|    Input '0'    Clk source select internal clk.                                      | \n");
	SYS_TEST("|    Input '1'    Clk source select external clk.                                      | \n");
	SYS_TEST("+--------------------------------------------------------------------------------------+ \n");
}




T_TRIM_TEST_RESULT TRIM_MeasureCase1(void)
{
	char c;
	uint8_t input = 0, sample_cnt;
	float real_freq;

	PrintClkSourceToBeTested();
	c = getchar();
	input = c - '0';
	CLKMEAS_SetMeasuredClkSrc(CLKMEAS, (CLKMEAS_ClkSrcSelDef)input);

	PrintSampleNumber();
	c = getchar();
	input = c - '0';
	sample_cnt = input;
	CLKMEAS_SetSampleNum(CLKMEAS, (CLKMEAS_SampleNumDef)input);
	
	PrintEdgeMode();
	c = getchar();
	input = c - '0';
	CLKMEAS_SetMeasureMode(CLKMEAS, (CLKMEAS_ModeSelDef)input);
	
	CLKMEAS_EnableInt(CLKMEAS, ENABLE);
	CLKMEAS_EnableMeasure(CLKMEAS, ENABLE);
	while(!stop_int_flag);
	stop_int_flag = 0;

	uint32_t real_cnt = CLKMEAS_GetMeasureCnt(CLKMEAS);
	real_freq = (float)FREQ_32MHZ / real_cnt * (1<<sample_cnt);
	SYS_TEST("measure clk is 32M clk, real freq is :%.2f \n", real_freq);
	CLKMEAS_EnableMeasure(CLKMEAS, DISABLE);
    return TRIM_TST_OK;
}
