/********************************************************* * 
@file		:adc_pwm_seq_one_ch_test.c 
@brief  	:pwm sequential mode in ad one channel test
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/10/28
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/

#include "pan271x.h"
#include "adc_common.h"


/*
  * @brief	   :iic register default value check
  * @retval    :0/1
*/
uint32_t ADC_PwmOneAdcChTest(void)
{
	uint16_t RcvDataBuf[128] = {0};
	char input;

	CLK_APB1PeriphClockCmd(CLK_APB1Periph_PWM0_EN|CLK_APB1Periph_PWM0_CH01,ENABLE);
    SYS_TEST("adc clk source select ahb/xth\n");
    CLK->APB1_CLK_CTRL0 |= APB1_CLK_CTRL0_ADC_CLK_SEL_Msk; //xth

	ADC_VrefVoltageSelect(ADC, ADC_VREF_VOL_SEL_VBAT);
	ADC_EnableFifo(ADC, ENABLE);
	ADC_LoadWeightCfg();
	ADC_SetWeightRatio(ADC, weight_dif);
	ADC_SetSampleCount(ADC, 4);
	ADC_SetDiscardCount(ADC, 0x1);
	ADC_EnableAverage(ADC, ENABLE);

	ADC_HwTrigEnable(ADC, ENABLE);
	ADC_HwTrigEdgeSelect(ADC, HW_TRIG_BY_FALLING_EDGE);
	ADC_HwTrigSrcSelect(ADC, HW_TRIG_SRC_PWM);
	ADC_PwmTrigSrcSelect(ADC, TRIG_BY_PWM_CH0_FLAG);
	ADC_EnableContinueSample(ADC, ENABLE);
	ADC_HwTrigEnable(ADC, ENABLE);
	ADC_PowerOn(ADC);

    // PWM0 frequency is 1200Hz, duty 30%,
    PWM_ConfigOutputChannel(PWM, 0, 1000, 50);
    // Enable output of 0 PWM channel
    PWM_EnableOutput(PWM, BIT0);
    // Start PWM
    PWM_Start(PWM, BIT0);
    
	uint32_t cnt = 0;
	while(cnt < 100){
		while(ADC_StatusFlag(ADC, ADC_STATUS_FIFO_HALF_FALG_Msk) == false);
		ADC_ReadFifo(ADC, RcvDataBuf+cnt);
		cnt += 4;
	}
	
    ADC_PowerDown(ADC);
	PWM_ForceStop(PWM,BIT0);
	CLK->IPRST1 |= IPRST1_PWM0RST_Msk;

	for(uint8_t cnt = 0;cnt < 100;cnt++){
		SYS_TEST("%d ",RcvDataBuf[cnt]);
		if(cnt % 10 == 9)
			SYS_TEST("\r\n");
	}
	CLK->IPRST1 &= ~IPRST1_PWM0RST_Msk;
    return 0;
}

