/********************************************************* * 
@file		:adc_convert_test.c 
@brief  	:adc convert function test
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/10/28
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/
#include "pan271x.h"
#include "adc_common.h"



uint32_t ADC_HwTimerTrigTest(void)
{
    uint16_t code_buf[ADC_CONV_CODE_TOTAL_CNT];

	GPIO_WritePin(1, 3, 0);
	SYS_SET_MFP(P1, 3, GPIO);
	GPIO_SetMode(P1, BIT3, GPIO_MODE_OUTPUT);

	ADC_IntEnable(ADC, ADC_CTL_EMPTY_INT_EN_Msk|ADC_CTL_OV_INT_EN_Msk
				|ADC_CTL_HALF_INT_EN_Msk|ADC_CTL_FULL_INT_EN_Msk|ADC_CTL_ADCIEN_Msk, DISABLE);
	ADC_HwTrigEnable(ADC, DISABLE);
	ADC_EnableFifo(ADC, ENABLE);
	ADC_VrefVoltageSelect(ADC, ADC_VREF_VOL_SEL_VBG);
	ADC_LoadWeightCfg();
	ADC_SetWeightRatio(ADC, weight_dif);
	ADC_SetSampleCount(ADC, 4);
	ADC_SetDiscardCount(ADC, 0x1);
	ADC_EnableAverage(ADC, ENABLE);
	ADC_HwTimerCmpSel(ADC, HW_TIMER_CMP_SEL_16K);
	ADC_HwTimerEnable(ADC, ENABLE);
    // Power on ADC
    ADC_PowerOn(ADC);

    // Delay a while to wait adc stable
//    SYS_delay_10nop(50000);

	uint32_t cnt = 100;
	while(cnt--){
		GPIO_WritePin(1, 3, 1);
		while(ADC_StatusFlag(ADC, ADC_STATUS_FIFO_EMPTY_FALG_Msk) == true);
		code_buf[99-cnt] = ADC_GetConversionData(ADC);
		GPIO_WritePin(1, 3, 0);
	}

	for(cnt = 0;cnt < 100;cnt++){
		SYS_TEST("%d ",code_buf[cnt]);
		if(cnt % 10 == 9)
			SYS_TEST("\r\n");
	}

    // Power down ADC
    ADC_PowerDown(ADC);

    return 0;
}

