/********************************************************* * 
@file		:adc_common.c 
@brief  	:common interface header file 
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/08/29
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/

#ifndef __ADC_USR_H__
#define __ADC_USR_H__

#define __BYTE_LEN	                    (32)

#define ADC_CONV_CODE_TOTAL_CNT     128


#define ADC_TEMPERATURE_CH	(ADC_CHEN_CH9_TMP_Msk)
#define ADC_TEST_CH			(ADC_CHEN_CHEN5_Msk)
#define ADC_CH_NUM			(ADC_CHEN_CHEN5_Pos)

extern volatile bool gTfrFlag,gRxTfrFlag,gTfrFlag1;
extern ADC_WEIGHT_OPT_T weight_dif;

void delay(uint32_t t);

uint32_t ADC_ConvertTest(void);
uint32_t ADC_InterruptTest(void);
uint32_t ADC_TemperatureTest(void);
uint32_t ADC_PwmOneAdcChTest(void);
uint32_t ADC_HwTimerTrigTest(void);

void _ADC_LoadWeightCfg(uint16_t s0, uint16_t s1, uint16_t s2, uint16_t s3,
						uint16_t s4, uint16_t s5, uint16_t s6, uint16_t s7,
						uint16_t s8, uint16_t s9, uint16_t s10, uint16_t s11,
						uint16_t s12, uint16_t s13, uint16_t s14, uint16_t s15);

void ADC_TestFunctionEnter(uint16_t Idx);

void ADC_LoadWeightCfg(void);
#endif

