/********************************************************* * 
@file		:adc_common.c 
@brief  	:common interface source file,store some common interface functions 
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/08/29
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/

#include "pan271x.h"
#include "adc_common.h"

volatile bool compare_finish_flag = false;
/*---------------------------------------------------------------------------------------------------------*/
/* Global variables                                                                                        */
/*---------------------------------------------------------------------------------------------------------*/
volatile bool gTfrFlag =false,gRxTfrFlag =false,gTfrFlag1 = false;

ADC_WEIGHT_OPT_T weight_dif;
/*---------------------------------------------------------------------------------------------------------*/
/* Define functions prototype                                                                              */
/*---------------------------------------------------------------------------------------------------------*/

uint32_t (*ADC_TestEntry[])(void) = 
{
    ADC_ConvertTest,
    ADC_InterruptTest,
    ADC_TemperatureTest,
	ADC_PwmOneAdcChTest,
	ADC_HwTimerTrigTest
};

void ADC_TestFunctionEnter(uint16_t Idx)
{
    (ADC_TestEntry[Idx])();
}


void delay(uint32_t t)
{
    while(t){t--;};
}


void _ADC_LoadWeightCfg(uint16_t s0, uint16_t s1, uint16_t s2, uint16_t s3, uint16_t s4, uint16_t s5, uint16_t s6, uint16_t s7, uint16_t s8, uint16_t s9, uint16_t s10, uint16_t s11, uint16_t s12, uint16_t s13, uint16_t s14, uint16_t s15)
{
	weight_dif.weight_difference_1_t.weight_difference_bit.S0 = s0;
	weight_dif.weight_difference_1_t.weight_difference_bit.S1 = s1;
	weight_dif.weight_difference_1_t.weight_difference_bit.S11 = s11;
	
	weight_dif.weight_difference_2_t.weight_difference_bit.S6 = s6;
	weight_dif.weight_difference_2_t.weight_difference_bit.S9 = s9;
	weight_dif.weight_difference_2_t.weight_difference_bit.S15 = s15;
	
	weight_dif.weight_difference_3_t.weight_difference_bit.S7 = s7;
	weight_dif.weight_difference_3_t.weight_difference_bit.S8 = s8;
	weight_dif.weight_difference_3_t.weight_difference_bit.S14 = s14;
	
	weight_dif.weight_difference_4_t.weight_difference_bit.S5 = s5;
	weight_dif.weight_difference_4_t.weight_difference_bit.S12 = s12;
	weight_dif.weight_difference_4_t.weight_difference_bit.S13 = s13;
	
	weight_dif.weight_difference_5_t.weight_difference_bit.S2 = s2;
	weight_dif.weight_difference_5_t.weight_difference_bit.S3 = s3;
	weight_dif.weight_difference_5_t.weight_difference_bit.S4 = s4;
	weight_dif.weight_difference_5_t.weight_difference_bit.S10 = s10;
}

void ADC_LoadWeightCfg(void)
{
	_ADC_LoadWeightCfg(8, 8, 8, 16, 32, 64, 96, 192, 352, 576, 1024, 1600, 2816, 5248, 7680, 13056);
}
