/****************************************************************************
 * @file     pan_otp.h
 * @version  V1.00
 * $Revision: 2 $
 * $Date: 2023/11/08
 * @brief    Panchip series OTP driver header file
 *
 * @note
 * Copyright (C) 2025 Panchip Technology Corp. All rights reserved.
 *****************************************************************************/

#ifndef __PAN_OTP_H__
#define __PAN_OTP_H__
/**
 * @brief Fmc Interface
 * @defgroup fmc_interface Fmc Interface
 * @{
 */
#define M32(adr) (*((vu32 *) (adr)))
#ifdef __cplusplus
extern "C"
{
#endif
#define PTM_USER_MAIN_AREA_PROGRAM			(0X00)
#define PTM_TEST_COL_PROGRAM				(0X04)
#define PTM_TEST_ROW_PROGRAM				(0X08)



#define PTM_USER_MAIN_AREA_READ				(0X00)
#define PTM_USER_MAIN_AREA_READ2			(0X10)

#define PTM_TEST_MAIN_AREA_WEAK_READ		(0X01)
#define PTM_TEST_MAIN_AREA_WEAK_READ2		(0X11)
#define PTM_TEST_MAIN_AREA_MARGAIN_READ		(0X02)
#define PTM_TEST_MAIN_AREA_MARGAIN_READ2	(0X12)

#define PTM_TEST_ROW_READ					(0X08)
#define PTM_TEST_ROW_READ2					(0X18)
#define PTM_TEST_ROW_WEAK_READ				(0X09)
#define PTM_TEST_ROW_WEAK_READ2				(0X19)
#define PTM_TEST_ROW_MARGAIN_READ			(0X0A)
#define PTM_TEST_ROW_MARGAIN_READ2			(0X1A)

#define PTM_TEST_COL_READ					(0X04)
#define PTM_TEST_COL_READ2					(0X14)
#define PTM_TEST_COL_WEAK_READ				(0X05)
#define PTM_TEST_COL_WEAK_READ2				(0X15)
#define PTM_TEST_COL_MARGAIN_READ			(0X06)
#define PTM_TEST_COL_MARGAIN_READ2			(0X16)

#define WORK_MODE_READ						(0)
#define WORK_MODE_WRITE						(1)
#define WORK_MODE_DEBUG						(2)
#define WORK_MODE_IDLE						(3)


/**
 * @brief       Set work mode to idle
 * @return      None
 */
__STATIC_INLINE void OTP_ChangeModeIdle(void)
{
    OTP->MODE_CTL = WORK_MODE_IDLE;
}


void OTP_ReadInit(uint8_t Ptm, bool ecc_en);
void OTP_ReadWord(uint32_t Addr, uint8_t *buf);
void OTP_WriteInit(uint8_t Ptm, bool ecc_en);
void OTP_WriteWord(uint32_t Addr, uint8_t *buf);
uint32_t OTP_Verify(uint32_t adr, uint32_t sz, uint8_t *buf);
void OTP_ReadStream(uint32_t adr, uint32_t sz, uint8_t *buf);
int8_t OTP_WriteStream(uint32_t adr, uint32_t sz, uint8_t *buf);
/**@} */
#ifdef __cplusplus
}
#endif
#endif //__PAN_OTP_H__

