#include <stdarg.h>
#include <ctype.h>



extern void SendChar(int ch);

void mini_printf(const char* fmt, ...) {
    va_list args;
    va_start(args, fmt);
    
    while (*fmt) {
        if (*fmt == '%') {
            fmt++;
            if (*fmt == 'd') {
                int num = va_arg(args, int);
                if (num < 0) {
                    SendChar('-');  // д
                    num = -num;
                }
                
                // ݹ֣ʹôջռ䣩
                if (num >= 10) {
                    mini_printf("%d", num / 10);
                }
                SendChar('0' + (num % 10));
                
            } else if (*fmt == 'x') {
                unsigned int num = va_arg(args, unsigned int);
                char hex_digits[] = "0123456789ABCDEF";
                
                // 0xǰ׺
                SendChar('0');
                SendChar('x');
                
                // 16
                int started = 0;
                for (int i = 7; i >= 0; i--) {
                    int digit = (num >> (i * 4)) & 0xF;
                    if (digit != 0 || started || i == 0) {
                        SendChar(hex_digits[digit]);
                        started = 1;
                    }
                }
            }
            fmt++;
        } else {
            SendChar(*fmt);
            fmt++;
        }
    }
    
    va_end(args);
}
