/**************************************************************************
 * @file     dongle_usb.h
 * @version  V1.00
 * $Revision: 3$
 * $Date: 2023/11/21 $
 *
 * @note
 * Copyright (C) 2023 Panchip Technology Corp. All rights reserved.
 *****************************************************************************/
#ifndef __DONGLE_USB_H__
#define __DONGLE_USB_H__

#include "pan271x.h"

#define STAND_KB_ENDPOINT               1
#define COMPOSITE_ENDPOINT              2       /* contain mouse report id 5*/
#define VENDOR_ENDPOINT                 3       /* dfu & emi */

#define USB_VENDOR_DFU_GET_VERSION                              0x00
#define USB_VENDOR_PRF_TEST                                     0x31
#define USB_GET_OWN_ADDR                                        0x35
#define USB_GET_PAIR_ADDR                                       0x36


/**
 * @brief dongle usb Interface
 * @defgroup dongle usb Interface
 * @{
 */

#ifdef __cplusplus
extern "C"
{
#endif

enum usb_stat_t {
	usb_active,
	usb_suspending,
	usb_suspended,
	usb_resuming,
	usb_plug_out
};

void usb_init(void);
void usb_report(void);

/**@} */

#ifdef __cplusplus
}
#endif

#endif // __DONGLE_USB_H__

/*** (C) COPYRIGHT 2023 Panchip Technology Corp. ***/
