/**************************************************************************
 * @file     dongle_p24c02.h
 * @version  V1.00
 * $Revision: 3$
 * $Date: 2023/11/21 $
 *
 * @note
 * Copyright (C) 2023 Panchip Technology Corp. All rights reserved.
 *****************************************************************************/
#ifndef __DONGLE_P24C02_H__
#define __DONGLE_P24C02_H__

#include "pan271x.h"


#ifdef __cplusplus
extern "C"
{
#endif

#define IIC_SCL_INIT		SYS_SET_MFP(P2,2,GPIO)
#define IIC_SCL_HIGH		GPIO_WritePin(2, 2, 1)
#define IIC_SCL_LOW			GPIO_WritePin(2, 2, 0)
#define IIC_SCL_OUT			GPIO_SetMode(P2, BIT2, GPIO_MODE_OPEN_DRAIN)

#define IIC_SDA_INIT		SYS_SET_MFP(P1,6,GPIO);
#define IIC_SDA_HIGH		GPIO_WritePin(1, 6, 1)
#define IIC_SDA_LOW			GPIO_WritePin(1, 6, 0)
#define IIC_SDA_GET			GPIO_ReadPin(1, 6)
#define IIC_SDA_OUT			GPIO_SetMode(P1, BIT6, GPIO_MODE_OPEN_DRAIN)
#define IIC_SDA_IN			GPIO_SetMode(P1, BIT6, GPIO_MODE_INPUT)

#define IIC_DELAY()			SYS_delay_10nop(50)

#define P24C02_ADDRESS 		0xA0

void IIC_Init(void);
bool P24C02_WritePage(uint8_t start_addr, const uint8_t *data, uint8_t len);
bool P24C02_ReadSequential(uint8_t start_addr, uint8_t *data, uint8_t len);

/**@} */

#ifdef __cplusplus
}
#endif

#endif // __DONGLE_P24C02_H__

/*** (C) COPYRIGHT 2023 Panchip Technology Corp. ***/
