/**************************************************************************//**
 * @file     main.c
 * @version  V1.00
 * $Date: 19/10/30 16:17 $
 * @note
 * Copyright (C) 2019 Panchip Technology Corp. All rights reserved.
 *
 ******************************************************************************/
#include <stdio.h>
#include "comm_prf.h"

pan_prf_config_t __align(4) rf_config = 
{
	.work_mode			= PRF_MODE_ENHANCE,//PRF_MODE_NORMAL,PRF_MODE_ENHANCE
	.chip_mode			= PRF_CHIP_MODE_SEL_XN297,//PRF_CHIP_MODE_SEL_NRF,//PRF_CHIP_MODE_SEL_XN297,
	.trx_mode			= PRF_RX_MODE,
	.phy				= PRF_PHY_1M,//PRF_PHY_250K,//PRF_PHY_1M,PRF_PHY_2M
	.crc				= PRF_CRC_SEL_CRC16,
	.scr				= PRF_SCR_SEL_NOSCR,
	.mode_conf			= PRF_XN297L_CONF,//PRF_BLE_CONF
	.pipe				= PRF_PIPE0,
	.rx_timeout			= 0,			//us
	.rf_channel			= 2410,
	.tx_no_ack			= DISABLE,
	.rx_length			= 5,
	.sync_length		= 4,
	.sync				= { 0x91, 0xD3, 0x91, 0xD3 },	
	.crc_include_sync	= DISABLE,
	.scr_include_sync	= DISABLE,
	.auto_pyl_flag		= DISABLE,
	.pid_manual_flag	= DISABLE,
	.endian				= PRF_BIG_ENDIAN,
	.tx_power			= 0,

};

panchip_prf_payload_t tx_payload = {
	.data_length		= 10,
	.data				= { 0x00, 0x011, 0x022, 0x033, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99 },
};

extern void mini_printf(const char* fmt, ...);
void data_printf(uint8_t const *data, uint32_t len)
{
	uint32_t i = 0;

	if (len == 0) 
	{
		return;
	}

	for (; i < len; i++) 
	{
		mini_printf("%x ", data[i]);
	}
	mini_printf("\n");
}

void event_tx_fun(void)
{
	if (((rf_config.work_mode == PRF_MODE_ENHANCE) || (rf_config.work_mode == PRF_MODE_NORMAL_M1)) && (rf_config.trx_mode == PRF_RX_MODE)) {
		panchip_prf_payload_t rx_payload;

		rx_payload.data_length = panchip_prf_data_rec(&rx_payload);
		data_printf(rx_payload.data, rx_payload.data_length);

		panchip_prf_trx_start();
	} else {
		mini_printf("tx done\n");
	}
}

void event_rx_fun(void)
{
	if ((rf_config.work_mode == PRF_MODE_NORMAL) && (rf_config.trx_mode == PRF_RX_MODE)) {
		panchip_prf_payload_t rx_payload;

		rx_payload.data_length = panchip_prf_data_rec(&rx_payload);
		data_printf(rx_payload.data, rx_payload.data_length);
	} else if ((rf_config.work_mode == PRF_MODE_ENHANCE) && (rf_config.trx_mode == PRF_TX_MODE)) {
		panchip_prf_payload_t rx_payload;

		rx_payload.data_length = panchip_prf_data_rec(&rx_payload);
		data_printf(rx_payload.data, rx_payload.data_length);
	} else if (rf_config.tx_no_ack == ENABLE) {
		panchip_prf_payload_t rx_payload;

		rx_payload.data_length = panchip_prf_data_rec(&rx_payload);
		data_printf(rx_payload.data, rx_payload.data_length);
	} else if((rf_config.work_mode == PRF_MODE_ENHANCE) && (rf_config.trx_mode == PRF_RX_MODE)) {
		tx_payload.data[0]++;
		panchip_prf_set_data(&tx_payload);
	}

	uint8_t ptxprx = PRI_RF_IsRxSel(PRI_RF);
	uint8_t enhc = PRI_RF_IsEnhance(PRI_RF);
	uint8_t rx_header = (uint8_t)((PRI_RF->R04_RX_CTL & R04_RX_CTL_RX_HEADER0_Msk) >> R04_RX_CTL_RX_HEADER0_Pos);
	uint8_t noack_invert = (uint8_t)((PRI_RF->R10_CFG & R10_CFG_NDC_ACK_SEL_Msk) >> R10_CFG_NDC_ACK_SEL_Pos);
	
	if (enhc == 0) {
		panchip_prf_trx_start();
	} else if (ptxprx && ((!noack_invert && !rx_header) || (noack_invert && rx_header))) {
		panchip_prf_trx_start();
	}
}

void event_rx_timeout_fun(void)
{
//	mini_printf("rx timeout\n");
	if (rf_config.trx_mode == PRF_RX_MODE) {
		panchip_prf_trx_start();
	}
}

void event_crc_err_fun(void)
{
	//	mini_printf("crc\n");
	if (rf_config.trx_mode == PRF_RX_MODE) {
		panchip_prf_trx_start();
	}
}

void event_pid_err_fun(void)
{
//	mini_printf("pid\n");
}

void panchip_prf_isr_init(void)
{
	isr_cb.tx_cb = event_tx_fun;
	isr_cb.rx_cb = event_rx_fun;
	isr_cb.rx_timeout_cb = event_rx_timeout_fun;
	isr_cb.rx_crc_err_cb = event_crc_err_fun;
	isr_cb.rx_pid_err_cb = event_pid_err_fun;
}

void panchip_prf_irq_enable(void)
{
	NVIC_SetPriority (LL_IRQn, 0);
	/* Enable RF interrupt */
	NVIC_EnableIRQ(LL_IRQn);
}

void systick_delay_ms(uint16_t ms)
{
	uint32_t ticks = 0;

	ticks = SystemCoreClock / 1000 * ms;
	if(ticks > 16777216)
	{
		ticks = 16777216;
	}

	SysTick->LOAD = ticks;
	SysTick->VAL =0x00;
	SysTick->CTRL = (SysTick_CTRL_ENABLE_Msk | SysTick_CTRL_CLKSOURCE_Msk);

	/* Waiting for down-count to zero */
    while((SysTick->CTRL & SysTick_CTRL_COUNTFLAG_Msk) == 0);

	SysTick->CTRL = 0;
}

void Clock_Init(void)
{
	PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_OTP_READ_MODE_SEL_Msk;
	PMU->SYS_CLK_CTRL &= ~(SYS_CLK_CTRL_OTP_CLK_HIGH_CYCLE_Msk | SYS_CLK_CTRL_OTP_CLK_LOW_CYCLE_Msk);
	#ifndef FPGA_MODE
	PMU->ANA_ANALDO |= ANA_ANALDO_EN_LDO_FSYN_AON_Msk;
    //MCU
	CLK_XthStartupConfig();
	PMU->XTH_CTRL |= XTH_CTRL_FSYNXO_BUFEN_AON_Msk;
	PMU->XTH_CTRL |= XTH_CTRL_FSYNXO_EN_AON_Msk;
	CLK_WaitClockReady(CLK_SYS_SRCSEL_XTH);

	CLK_HCLKConfig(0);

	CLK_SYSCLKConfig(CLK_DPLL_REF_CLKSEL_XTH,CLK_DPLL_OUT_48M); 
	CLK_RefClkSrcConfig(CLK_SYS_SRCSEL_XTH);
	#endif

	CLK_AHBPeriphClockCmd(CLK_AHBPeriph_APB1,ENABLE);
	CLK_APB1PeriphClockCmd(CLK_APB1Periph_ADC|CLK_APB1Periph_UART0,ENABLE);
	
	//PMU->XTH_CTRL = (PMU->XTH_CTRL & ~XTH_CTRL_FSYNXO_CAPSEL_AON_Msk) | (0x30 << XTH_CTRL_FSYNXO_CAPSEL_AON_Pos);
}


void Sys_Init(void)
{
    /* Unlock protected registers */
    SYS_UnlockReg();

    /* Init I/O Multi-function  */
	SYS_SET_MFP(P0,6,UART0_RX);
	SYS_SET_MFP(P0,5,UART0_TX);
	GPIO_EnableDigitalPath(P0,BIT6);

	UART_Init(UART0, 115200);
	
    SYS_LockReg();
}


/*------------------
    Main function
 ------------------*/
int main(void)
{
    Clock_Init();
    Sys_Init();

	mini_printf("\nCPU @ %dHz\n", SystemCoreClock);

	panchip_prf_init(&rf_config);

	panchip_prf_trx_start();
	while(1) {	
	}
}
