/*******************************************************************************
 * @note      Copyright (C) 2019 Shanghai Panchip Microelectronics Co., Ltd.
 *            All rights reserved.
 * @file      user_lp.c
 * @brief     Low Power test
 * @history - V1.0, 2019-3-21, zhangzhao, first implementation.
*******************************************************************************/
#include "pan271x.h"
#include "lp_common.h"

uint32_t vec_remap_adr = 0x20000b00;

uint32_t LP_ContinuesSleepWakeByGpioClk32k(void)
{
	uint32_t tmp_reg;
	uint32_t wkupMode = LP_WKUP_MODE_SEL_EXT_GPIO;
	uint32_t dpMode = LP_DEEPSLEEP_MODE1;

	//set test pin
	GPIO_WritePin(1, 7, 0);
	SYS_SET_MFP(P1,7,GPIO);
	GPIO_SetMode(P1, BIT7, GPIO_MODE_OUTPUT);
	
	GPIO_WritePin(2, 0, 0);
	SYS_SET_MFP(P2,0,GPIO);
	GPIO_SetMode(P2, BIT0, GPIO_MODE_OUTPUT);
	
	tmp_reg = PMU->CPU_ADDR_REMAP_CTRL;
	memcpy((void*)vec_remap_adr, (void*)(0x0), 256);
	tmp_reg &= ~CPU_ADDR_REMAP_CTRL_CPU_REMAP_ADDR_Msk;
	tmp_reg |= ((vec_remap_adr >> 8) & CPU_ADDR_REMAP_CTRL_CPU_REMAP_ADDR_Msk);
	tmp_reg |= CPU_ADDR_REMAP_CTRL_CPU_ADDR_REMAP_EN_Msk;
	PMU->CPU_ADDR_REMAP_CTRL = tmp_reg;
	PMU->LP_CTRL0 |= LP_CTRL0_CPU_LP_RET_EN_Msk;
	
	special_case_test = true;
	
	char ldol[4], ldoh[4];

	SYS_TEST("Input 'A' mode1 selected\n");
	SYS_TEST("Input 'B' mode2 selected\n");
	char mode;
	mode = getchar();
	if ((mode == 'A') || (mode == 'a'))
		dpMode = LP_DEEPSLEEP_MODE1;
	else
		dpMode = LP_DEEPSLEEP_MODE2;
	SYS_delay_10nop(1000);
	uint32_t lpldo1;
	uint32_t lpldoh;
	SYS_TEST("Input lpldol trim\n");
	gets(ldol);
	lpldo1 = atoi(ldol);
	SYS_TEST("lpldol = %x\n", lpldo1);
	SYS_delay_10nop(1000);
	SYS_TEST("Input lpldoh trim\n");
	gets(ldoh);
	lpldoh = atoi(ldoh);
	SYS_TEST("lpldoh = %x\n", lpldoh);
	SYS_delay_10nop(1000);

	tmp_reg = PMU->ANA_LPLDO;
	tmp_reg &= ~ANA_LPLDO_PMU_LPLDOH_VSEL_AON_Msk;
	tmp_reg = (tmp_reg & ~(0xf << 20)) | (lpldoh << 20);
	PMU->ANA_LPLDO = tmp_reg;
	tmp_reg = PMU->ANA_RESERVED;
	tmp_reg &= ~ANA_RESERVED_PMU_LPLDOL_VSEL_AON_Msk;
	tmp_reg = (tmp_reg & ~(0xf<<17)) | (lpldo1 << 17);
	PMU->ANA_RESERVED = tmp_reg;


	GPIO_DisableDigitalPath(P0,0x03);
	GPIO_DisablePullupPath(P0,0x03);

	GPIO_ClrAllIntFlag(P1);
	__NVIC_ClearPendingIRQ(GPIO1_IRQn);	
	GPIO_DisableInt(P1,2);

	SYS_TEST("\r\nwake up by gpio P12 or 32K \r\n");
	SYS_delay_10nop(10000);
	GPIO_DB->DBCTL |= GP_DBCTL_DBCLKSRC_Msk;
	SYS_SET_MFP(P1, 2, GPIO);
	GPIO_SetMode(P1,BIT2,GPIO_MODE_INPUT);
	GPIO_EnableDigitalPath(P1,BIT2);
	GPIO_EnablePulldownPath(P1, BIT2);
	GPIO_EnableInt(P1,2,GPIO_INT_RISING);
	GPIO_ClrAllIntFlag(P1);
	__NVIC_ClearPendingIRQ(GPIO1_IRQn);
	NVIC_EnableIRQ(GPIO1_IRQn);
	
	LP_SetSleepTimerConfig(PMU, SLPTMR_CTRL_SLPTMR_EN_Msk | SLPTMR_CTRL_SLPTMR_INT_EN_Msk
							| SLPTMR_CTRL_SLPTMR_CMP0_EN_Msk | SLPTMR_CTRL_SLPTMR_WK_EN_Msk,
							ENABLE);
	LP_SetUsrSleepTimer(32000 * 2, 0);
	wkupMode = LP_WKUP_MODE_SEL_32K;
//	dpMode = LP_DEEPSLEEP_MODE1;
	
	GPIO_DisableDigitalPath(P0,BIT6);
	LP_SetOtpCeDelayTime(PMU, 0XA);
	LP_SetOtpPowerDelayTime(PMU, 0X2);
	LP_SetDeepSleepConfig(PMU,wkupMode,dpMode);
	SYS_delay_10nop(1000);
	while (1) {
		if (rcl32k_wakeup) {
			LP_SetUsrSleepTimer(32000 * 2, 0);
		}
		rcl32k_wakeup = false;

		__WFI();

		GPIO_WritePin(1, 7, 0);
		GPIO_WritePin(2, 0, 0);
	}
}

