/********************************************************* * 
@file		:spi_common.c 
@brief  	:common interface header file 
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/08/29
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/
#ifndef __LP_COMMON_H__
#define __LP_COMMON_H__

#define RAM_FUNC // __attribute__((section(".ram.text")))

#define WK_BY_32K_TIMER_0	('A')
#define WK_BY_32K_TIMER_1	('a')
#define WK_BY_GPIO_0		('B')
#define WK_BY_GPIO_1		('b')
#define WK_BY_WDT_0			('C')
#define WK_BY_WDT_1			('c')
#define WK_BY_BOD_0			('D')
#define WK_BY_BOD_1			('d')
#define WK_BY_LVR_0			('E')
#define WK_BY_LVR_1			('e')
#define WK_BY_TIMER0_0		('f')
#define WK_BY_TIMER0_1		('F')
#define WK_BY_GPIO_P02_0	('G')
#define WK_BY_GPIO_P02_1	('g')


extern uint32_t cycleCnt;
extern bool special_case_test, rcl32k_wakeup;
extern volatile bool gTfrFlag, gRxTfrFlag, gTfrFlag1;
extern uint32_t gTxChNum;

void FillBuffer(uint8_t *pBuffer, uint32_t size);
void Delay_1us(uint32_t us);
void LP_SetUsrSleepTimer(uint32_t sleepTime, uint8_t idx);

void Peri_Init(void);
void Int_Enable(void);
void FMC_SetRdpCmdAfterWakeUp(void);
	
uint32_t LP_SleepModeTest(void);
uint32_t LP_StandbyModeTest(void);
uint32_t LP_DeepSleepPwmOutTest(void);
uint32_t LP_ContinuesSleepWakeByGpioClk32k(void);
uint32_t LP_ContinuesStdbyWakeByGpioClk32k(void);
void Wfi_With_Recover(void);

void LP_TestFunctionEnter(uint16_t Idx);


#endif  //__SPI_COMMON_H__
