/*******************************************************************************
 * @note      Copyright (C) 2020 Shanghai Panchip Microelectronics Co., Ltd.
 *            All rights reserved.
 * @file      main.c
 * @brief     CoreMark Sample Code
 * @history - V1.0, 2019-03-21, zhangzhao, first implementation.
            - V1.1, 2020-09-03, lihui, porting for PN108C.
*******************************************************************************/
#include "pan271x.h"
#include "coremark.h"

void Clock_Init(void)
{
    PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_OTP_READ_MODE_SEL_Msk;
    PMU->SYS_CLK_CTRL &= ~(SYS_CLK_CTRL_OTP_CLK_HIGH_CYCLE_Msk | SYS_CLK_CTRL_OTP_CLK_LOW_CYCLE_Msk);
    PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_OTP_SW_UP_CYCLE_EN_Msk;

    PMU->ANA_ANALDO |= ANA_ANALDO_EN_LDO_FSYN_AON_Msk;

    CLK_XthStartupConfig();
    PMU->XTH_CTRL |= XTH_CTRL_FSYNXO_BUFEN_AON_Msk;
    PMU->XTH_CTRL |= XTH_CTRL_FSYNXO_EN_AON_Msk;
    CLK_WaitClockReady(CLK_SYS_SRCSEL_XTH);

    CLK_HCLKConfig(0);
    CLK_RefClkSrcConfig(CLK_SYS_SRCSEL_XTH);

    CLK_AHBPeriphClockCmd(CLK_AHBPeriph_All,ENABLE);
    CLK_APB1PeriphClockCmd(CLK_APB1Periph_All,ENABLE);
}

void Peri_Init(void)
{
    SYS_UnlockReg();

    /* Init I/O Multi-function  */
    SYS_SET_MFP(P0, 6, UART0_RX);
    SYS_SET_MFP(P0, 5, UART0_TX);
    GPIO_EnableDigitalPath(P0, BIT6);

    UART_Init(UART0, 115200);

    SYS_LockReg();
}

void platform_init()
{
    Clock_Init();
    Peri_Init();
}

int main(void)
{
    platform_init();

    SYS_TEST("\nCPU @ %dHz\n", SystemCoreClock);

    SYS_TEST("CoreMark start...\n");

    core_main();

    while (1) {}
}
