/**************************************************************************//**
 * @file     wdt_common.c
 * @version  V1.0
 * $Date:    19/11/12 17:17 $
 * @brief    Common source file for WDT test.
 *
 * @note
 * Copyright (C) 2019 Panchip Technology Corp. All rights reserved.
 *
 ******************************************************************************/
#include <ctype.h>
#include "pan271x.h"
#include "wdt_common.h"


T_WDT_TEST_RESULT (*const WDT_TestCase[])(void) = 
{
    WDT_InterruptModeTestCase,
    WDT_ResetModeTestCase,
};

void WDT_TestFunctionEnter(uint16_t TcIdx)
{
    T_WDT_TEST_RESULT r = WDT_TST_OK;

    if (TcIdx >= sizeof(WDT_TestCase) / sizeof(void*))
    {
        SYS_TEST("Error, cannot find Testcase %d!", TcIdx);
        return;
    }

    r = (WDT_TestCase[TcIdx])();
    if (r != WDT_TST_OK)
    {
        SYS_TEST("WDT Test Fail, Fail case: %d, Error Code: %d\n", TcIdx, r);
    }
    else
    {
        SYS_TEST("WDT Test OK, Success case: %d\n", TcIdx);
    }
}


void WDT_IRQHandler(void)
{
	if(WDT_GetTimeoutIntFlag())
	{
		WDT_ClearTimeoutIntFlag();
		WDT_ClearTimeoutFlag();
		WDT_ClearTimeoutWakeupFlag();
	}

    // Pulse LA_INPUT_PIN to indicate WDT Int occurred
	GPIO_WritePin(2, 0, 0);
    SYS_delay_10nop(1);
	GPIO_WritePin(2, 0, 1);
    SYS_TEST("WDT INT\n");
}


void WDT_ResetRegionSelect(void)
{
	char input;

	SYS_UnlockReg();
	SYS_TEST("wdt reset region select\n");
	SYS_TEST("a:  only 1p2v region reset\n");
	SYS_TEST("b:  all chip reset without rom mode\n");
	input = getchar();
	switch(input){
		case 'A':
		case 'a':
			WDT->CTL &= ~WDT_CTL_RST_REGION_SEL_Msk;;
			break;
		case 'B':
		case 'b':
			WDT->CTL |= WDT_CTL_RST_REGION_SEL_Msk;;
			break;
		default:break;
	}
}

void WDT_TestModuleInit(void)
{
    // Enable Clock
    CLK_APB1PeriphClockCmd(CLK_APB1Periph_WDT, ENABLE);     //Enable WDT Clock
    CLK_APB1PeriphClockCmd(CLK_APB1Periph_TMR0, ENABLE);    //Enalbe Timer0 Clock for TIMER_Delay()

    // Config Pinmux of Auxiliary GPIO for Timing Measure by Logic Analyzer
    SYS_SET_MFP(P2, 0, GPIO);
    GPIO_SetMode(P2, BIT0, GPIO_MODE_OUTPUT);
    /* NOTE: We should make sure LA_INPUT_PIN in wdt_common.h is defined as the same pin (P12) !!! */
}
