/**************************************************************************//**
 * @file     uart_common.h
 * @version  V1.0
 * $Date:    19/09/25 14:00 $
 * @brief    Header file for UART test.
 *
 * @note
 * Copyright (C) 2019 Panchip Technology Corp. All rights reserved.
 *
 ******************************************************************************/
#ifndef __UART_COMMON_H__
#define __UART_COMMON_H__

#include <stdint.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C"
{
#endif

#define CHAR_NONE       (-1)

typedef enum _T_UART_TST_RESULT
{
    UART_TST_OK,
} T_UART_TEST_RESULT;

// Config UART software buffer size
#define UART_RX_BUF_SIZE        128
#define UART_TX_BUF_SIZE        128

// Config UART for Debug/Log
#define DEBUG_PORT      UART0   //Note this define should be same with that in retarget.c


#define TEST_UART0      0
#define TEST_UART1      1


#define TGT_UART            UART1
#define TGT_UART_IRQn       UART1_IRQn

// Test Case Functions
extern T_UART_TEST_RESULT UART_BaudrateTestCase1(void);
extern T_UART_TEST_RESULT UART_InterruptTestCase2(void);

extern void UART_TestFunctionEnter(uint16_t TcIdx);
extern void TGT_ClrAllReadyData(void);
extern char TGT_GetChar(uint32_t* line_status);
extern void TGT_ReceiveMultiData(uint8_t* data, size_t expect_size);
//extern bool TGT_ReceiveMultiData9Bit(uint8_t* data, size_t expect_size, uint8_t recv_addr, volatile bool* addr_rcvd_flag);
extern void TGT_SendMultiData(const uint8_t* data, size_t size);
extern char* Hexlify(const uint8_t* bin_in, size_t n, char* hex_out);

extern volatile uint8_t uartRxBuffer[UART_RX_BUF_SIZE];
extern volatile uint8_t uartTxBuffer[UART_TX_BUF_SIZE];
extern volatile uint8_t uartRxBufIdx;
extern volatile uint32_t uartTxBufIdx;
extern volatile uint32_t uartTxMark;
extern volatile bool uartTxDone;
extern volatile uint32_t rxRcvNum;
	
#ifdef __cplusplus
}
#endif

#endif //__UART_COMMON_H__
