/**************************************************************************//**
 * @file     main.c
 * @version  V1.00
 * $Date: 19/10/22 14:17 $
 * @brief    SPI Sample Code. Use SPI to transmit/receive data by polling or
 *           interrupt mode, set frame format to Motorola SPI or TI Synchronous
 *           Serialuse, work with DMA, etc.
 * @note
 * Copyright (C) 2019 Panchip Technology Corp. All rights reserved.
 *
 ******************************************************************************/
#include "pan271x.h"
#include "spi_common.h"


void Clock_Init(void)
{
	PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_OTP_READ_MODE_SEL_Msk;
	PMU->SYS_CLK_CTRL &= ~(SYS_CLK_CTRL_OTP_CLK_HIGH_CYCLE_Msk | SYS_CLK_CTRL_OTP_CLK_LOW_CYCLE_Msk);
	PMU->SYS_CLK_CTRL |= ((0x1 << SYS_CLK_CTRL_OTP_CLK_HIGH_CYCLE_Pos) | (0x0 << SYS_CLK_CTRL_OTP_CLK_LOW_CYCLE_Pos));
	PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_OTP_SW_UP_CYCLE_EN_Msk;

	PMU->ANA_ANALDO |= ANA_ANALDO_EN_LDO_FSYN_AON_Msk;
    //MCU
	CLK_XthStartupConfig();
	PMU->XTH_CTRL |= XTH_CTRL_FSYNXO_BUFEN_AON_Msk;
    PMU->XTH_CTRL |= XTH_CTRL_FSYNXO_EN_AON_Msk;
	CLK_WaitClockReady(CLK_SYS_SRCSEL_XTH);

	CLK_HCLKConfig(0);

	CLK_SYSCLKConfig(CLK_DPLL_REF_CLKSEL_XTH,CLK_DPLL_OUT_48M); 
	CLK_RefClkSrcConfig(CLK_SYS_SRCSEL_DPLL_1);

	CLK_AHBPeriphClockCmd(CLK_AHBPeriph_All,ENABLE);
	CLK_APB1PeriphClockCmd(CLK_APB1Periph_All,ENABLE);
}


void Sys_Init(void)
{
    /* Unlock protected registers */
    SYS_UnlockReg();

    /* Init I/O Multi-function  */
	SYS_SET_MFP(P0,6,UART0_RX);
	SYS_SET_MFP(P0,5,UART0_TX);
	GPIO_EnableDigitalPath(P0,BIT6);

	UART_Init(UART0, 115200);
    SYS_LockReg();
}

void SPI_PrintSampleInfo()
{
    SYS_TEST("\n");
    SYS_TEST("+--------------------------------------------------------------------------------------+ \n");
    SYS_TEST("|                       PAN271x SPI Sample Code.                                       | \n");
    SYS_TEST("+--------------------------------------------------------------------------------------+ \n");
    SYS_TEST("|    Press key to start specific testcase:                                             | \n");
    SYS_TEST("|                                                                                      | \n");
    SYS_TEST("|    Input '1'    Testcase 1: Interrupt Test.                                          | \n");
    SYS_TEST("|    Input '2'    Testcase 2: Simple Transmission Demo.                                | \n");
    SYS_TEST("+--------------------------------------------------------------------------------------+ \n");
}


/*------------------
    Main function
 ------------------*/
int main(void)
{
    char c;
	
    Clock_Init();
	
	CLK->IPRST1 |= IPRST1_UART0RST_Msk;
	CLK->IPRST1 &= ~IPRST1_UART0RST_Msk;
    Sys_Init();

    SPI_TestModuleInit();
    SPI_PrintSampleInfo();
    c = getchar();
    while( c )
    {
        SYS_TEST("\n");
        switch(c)
        {
            /* 1. Interrupt Test. */
            case '1':
                SPI_TestFunctionEnter(0);
                break;
            /* 2. Simple Transmission Demo */
            case '2':
                SPI_TestFunctionEnter(1);
                break;
			default:
                SYS_WARN("Cannot find testcase %c!\n", c);
                break;
        }
        SPI_PrintSampleInfo();
        c = getchar();
    }
}
