/**************************************************************************//**
 * @file     pwm_common.h
 * @version  V1.0
 * $Date:    19/11/06 17:10 $
 * @brief    Common header file for PWM test.
 *
 * @note
 * Copyright (C) 2019 Panchip Technology Corp. All rights reserved.
 *
 ******************************************************************************/
#ifndef __PWM_COMMON_H__
#define __PWM_COMMON_H__

#include <stdint.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C"
{
#endif

#define CHAR_NONE       (-1)

typedef enum _T_PWM_TST_RESULT
{
    PWM_TST_OK,
} T_PWM_TEST_RESULT;


// Config Target PWM Channel for Test
#define TGT_PWM_CH      PWM_CH2
#define AUX_PWM_CH      PWM_CH3

#define TEST_PWM0       0

#define TGT_PWM         PWM
#define TGT_PWM_IRQ     PWM_IRQn
#define FLAG_PIF_HIGH        GPIO_SetOutData(P2, (GPIO_GetOutData(P2) | BIT0))     			//GPIO PIN flag to indicate PIF signal
#define FLAG_PIF_LOW         GPIO_SetOutData(P2, (GPIO_GetOutData(P2) & ~BIT0))     //GPIO PIN flag to indicate PIF signal
#define FLAG_CMPDIF_HIGH     GPIO_SetOutData(P2, (GPIO_GetOutData(P2) | BIT1))     //GPIO PIN flag to indicate CMPDIF signal
#define FLAG_CMPDIF_LOW      GPIO_SetOutData(P2, (GPIO_GetOutData(P2) & ~BIT1))     //GPIO PIN flag to indicate CMPDIF signal


extern T_PWM_TEST_RESULT PWM_OperationModesTestCase(void);
extern T_PWM_TEST_RESULT PWM_PolarityControlTestCase(void);

extern void PWM_TestFunctionEnter(uint16_t TcIdx);
extern void PWM_TestModuleInit(void);

extern volatile uint16_t speed_div;

#ifdef __cplusplus
}
#endif

#endif //__PWM_COMMON_H__
