/*******************************************************************************
 * @note      Copyright (C) 2019 Shanghai Panchip Microelectronics Co., Ltd.
 *            All rights reserved.
 * @file      main.c
 * @brief     Use FMC driver to performe flash operations and IAP feature.
 *            Flash operation include erasing, writting and reading
 *            IAP feature include running to LDROM without reset
 * @history - V1.0, 2019-3-20, lujiabo, first implementation.
*******************************************************************************/
#include "pan271x.h"
#include "otp_common.h"

/*---------------------------------------------------------------------------------------------------------*/
/* Define functions prototype                                                                              */
/*---------------------------------------------------------------------------------------------------------*/

void Clock_Init(void)
{
	PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_OTP_READ_MODE_SEL_Msk;
	PMU->SYS_CLK_CTRL &= ~(SYS_CLK_CTRL_OTP_CLK_HIGH_CYCLE_Msk | SYS_CLK_CTRL_OTP_CLK_LOW_CYCLE_Msk);
	PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_OTP_SW_UP_CYCLE_EN_Msk;

	PMU->ANA_ANALDO |= ANA_ANALDO_EN_LDO_FSYN_AON_Msk;
    //MCU
	CLK_XthStartupConfig();
	PMU->XTH_CTRL |= XTH_CTRL_FSYNXO_BUFEN_AON_Msk;
    PMU->XTH_CTRL |= XTH_CTRL_FSYNXO_EN_AON_Msk;
	CLK_WaitClockReady(CLK_SYS_SRCSEL_XTH);
	
	CLK_HCLKConfig(0);
	CLK_RefClkSrcConfig(CLK_SYS_SRCSEL_XTH);

	CLK_AHBPeriphClockCmd(CLK_AHBPeriph_All,ENABLE);
	CLK_APB1PeriphClockCmd(CLK_APB1Periph_All,ENABLE);
}

void Peri_Init(void)
{
    SYS_UnlockReg();

	/* Set gpio driver ability */
	GPIO_DB->DBCTL |= ((0X3 << 18) | (0X1 << 24));
    /* Init I/O Multi-function  */
	SYS_SET_MFP(P0,6,UART0_RX);
	SYS_SET_MFP(P0,5,UART0_TX);
	GPIO_EnableDigitalPath(P0,BIT6);

	UART_Init(UART0, 115200);
	
    SYS_LockReg();
}

void platform_init()
{	
    Clock_Init();
    Peri_Init();
}

int main(void)
{
    platform_init();

	SYS_TEST("\nCPU @ %dHz\n", SystemCoreClock);

    while(1)
    {
		OTP_ReadTest();
    }
}
