/********************************************************* * 
@file       :ks_int_test.c 
@brief      :keyscan interrupt function test
@author     :zhongfeng
@version    :v1.0 
@date       :19/10/28
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/
#include "pan271x.h"
#include "ks_common.h"


uint32_t KS_DelayDisableTestCase5(void)
{
    uint32_t keyscanDiv = 50;

    NVIC_EnableIRQ(KSCAN_IRQn);

    uint32_t apb2Clk = CLK_GetPCLK1Freq();

	CLK_SetKeyscanClkSrc(CLKTRIM_KSCAN_CLK_SEL_32K);
	CLK_SetKeyscanDiv(keyscanDiv);
//	KS_SetFrameInterval(KSCAN,KS_INTERVAL_TIME_CLK_4);
	KS_SetRowInterval(KSCAN,KS_INTERVAL_TIME_CLK_128);
//	KS_SetDebounceTime(KSCAN,KS_INTERVAL_TIME_CLK_8K);

    KS_IntEnable(KSCAN,ENABLE);
    KS_Enable(KSCAN,ENABLE,KS_PERIPHRAL_ENABLE);
    SYS_delay_10nop(3000);
	GPIO_WritePin(1, 3, 0);
	KSCAN->KS_EN |= KS_DLY_DISABLE_Msk;
	GPIO_WritePin(1, 3, 1);
	while(KSCAN->KS_EN & KS_DLY_DISABLE_Msk){}
	SYS_TEST("KSCAN->KS_EN:%x \n",KSCAN->KS_EN);

    while(1) {
        char c = getchar();
        if(c == 0x1b)
            break;
    }
    return 0;
}
