/********************************************************* * 
@file		:iic_common.h
@brief  	:common interface header file 
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/08/29
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/

#ifndef __IIC_COMMON_H__
#define __IIC_COMMON_H__

#define BUFSIZE                         (256)
#define __BYTE_LEN	                    (32)


#define I2C_SLAVE_OWN_ADDRESS7          (0x50)
#define I2C_SLAVE_OWN_ADDRESS10         (0x350)
#define I2C_MASTER_TAR_ADDRESS7         (0xA0)//0xA8


void FillBuffer(uint8_t *pBuffer, uint32_t size);
void delay(uint32_t t);


uint32_t I2C_MasterSendDataCase(void);
uint32_t I2C_MasterReceiveDataCase(void);

void I2C_TestFunctionEnter(uint16_t Idx);

#endif /* __IIC_COMMON_H__ */

