/********************************************************* * 
@file		:iic_common.c 
@brief  	:common interface source file,store some common interface functions 
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/08/29
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/
#include "pan271x.h"
#include "i2c_common.h"

/*---------------------------------------------------------------------------------------------------------*/
/* Global variables                                                                                        */
/*---------------------------------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------------------------------*/
/* Define functions prototype                                                                              */
/*---------------------------------------------------------------------------------------------------------*/

uint32_t (*I2C_TestEntry[])(void) = 
{
	I2C_MasterSendDataCase,
	I2C_MasterReceiveDataCase,
};

void I2C_TestFunctionEnter(uint16_t Idx)
{
    (I2C_TestEntry[Idx])();
}

void I2C0_IRQHandler()
{

}

void delay(uint32_t t)
{
    while(t){t--;};
}


void FillBuffer(uint8_t *pBuffer, uint32_t size)
{
    uint32_t idx = 0;
    
    for(idx = 0; idx < size; idx++)
    {
        pBuffer[idx] = (uint8_t)(idx % 0x100);
    }
}
