/********************************************************* * 
@file		:i2c_status_check.c 
@brief  	:i2c status check case
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/10/16
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/

#include "pan271x.h"
#include "i2c_common.h"

void I2C_PrintBaudrateInfo(void)
{
    SYS_TEST("\n");
    SYS_TEST("+-------------------------------------------------------------+ \n");
    SYS_TEST("|    Press key to slect baudrate div testcase:                | \n");
    SYS_TEST("|                                                             | \n");
    SYS_TEST("|    Input '0'  I2C_DIV_256                                   | \n");
    SYS_TEST("|    Input '1'  I2C_DIV_224                                   | \n");
    SYS_TEST("|    Input '2'  I2C_DIV_192                                   | \n");
    SYS_TEST("|    Input '3'  I2C_DIV_160                                   | \n");
    SYS_TEST("|    Input '4'  I2C_DIV_960                                   | \n");
    SYS_TEST("|    Input '5'  I2C_DIV_120                                   | \n");
    SYS_TEST("|    Input '6'  I2C_DIV_60                                    | \n");
    SYS_TEST("+--------------------------------------------------------------------------------------+ \n");
}

static uint8_t I2C_WriteWithoutUsrAddr(uint8_t *buf, uint8_t length)
{
    uint8_t i;
    uint8_t ret;

    ret = I2C_Start();
    if (ret != TRUE)
    {
		SYS_TEST("start error\n");
        goto exit;
    }

    ret = I2C_SendDevAddr(I2C_MASTER_TAR_ADDRESS7, I2C_WRITE);
    if (ret != TRUE)
    {
		SYS_TEST("addr send error\n");
        goto exit;
    }

    for (i = 0; i < length; i++)
    {
        ret = I2C_WriteByte(buf[i]);
        if (ret != TRUE)
        {
			SYS_TEST("write data error\n");
            goto exit;
        }
    }

exit:
    I2C_Stop(); // Send stop signal
    return ret;
}


uint32_t I2C_BaudrateTestCase(void)
{
	char input;
    uint8_t WriteBuf[__BYTE_LEN+1] = {0};

    while(1)
    {
        I2C_PrintBaudrateInfo();
		input = getchar();
        switch(input)
        {
        case '0':
			I2C_DeInit();
			I2C_Init(I2C_DIV_256);
            break;
        case '1':
			I2C_DeInit();
			I2C_Init(I2C_DIV_224);
            break;
        case '2':
			I2C_DeInit();
			I2C_Init(I2C_DIV_192);
            break;
        case '3':
			I2C_DeInit();
			I2C_Init(I2C_DIV_160);
            break;
        case '4':
			I2C_DeInit();
			I2C_Init(I2C_DIV_960);
            break;
        case '5':
			I2C_DeInit();
			I2C_Init(I2C_DIV_120);
            break;
        case '6':
			I2C_DeInit();
			I2C_Init(I2C_DIV_60);
            break;
        case 0x1B:  // Keyboard code <ESC>
            goto OUT;
        default:
            SYS_WARN("Cannot find subtest case %c!\n", input);
            break;
        }
		FillBuffer(WriteBuf,__BYTE_LEN);
		I2C_WriteWithoutUsrAddr(WriteBuf, __BYTE_LEN);
    }

OUT:
    return 0;
}

