/**************************************************************************//**
 * @file     gpio_common.h
 * @version  V1.0
 * $Date:    19/09/03 17:00 $
 * @brief    Header file for GPIO test.
 *
 * @note
 * Copyright (C) 2019 Panchip Technology Corp. All rights reserved.
 *
 ******************************************************************************/
#ifndef __GPIO_COMMON_H__
#define __GPIO_COMMON_H__

#include <stdint.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C"
{
#endif

typedef enum _T_GPIO_TST_RESULT
{
    GPIO_TST_OK,
    GPIO_TST_TGT_PULL_UP_FAIL,
    GPIO_TST_TGT_PULL_DOWN_FAIL,
    GPIO_TST_TGT_INPUT_GET_0_FAIL,
    GPIO_TST_TGT_INPUT_GET_1_FAIL,

    GPIO_TST_TGT_PULL_UP_MASK_FAIL,
    GPIO_TST_TGT_PULL_DOWN_MASK_FAIL,
} T_GPIO_TEST_RESULT;

#define GPIO_INTEN_MASK_BASE                0x00010001UL
#define GPIO_INTTYPE_MASK_BASE              0x00000001UL

/* PIN ID Definitions */
#define P0_0            0x00
#define P0_1            0x01
#define P0_2            0x02
#define P0_3            0x03
#define P0_4            0x04
#define P0_5            0x05
#define P0_6            0x06
#define P0_7            0x07
#define P1_0            0x10
#define P1_1            0x11
#define P1_2            0x12
#define P1_3            0x13
#define P1_4            0x14
#define P1_5            0x15
#define P1_6            0x16
#define P1_7            0x17
#define P2_0            0x20
#define P2_1            0x21
#define P2_2            0x22

/*--------------- Configurations for Test ---------------*/
// Disable this macro if there is already external pullup resistor when testing open-drain mode / quasi mode
#define ENABLE_INTERNAL_PULLUP_RES


// GPIO Driver Wrapper Defines
#define GPIO_GET_PORT(PinId)    (PinId / 0x10)
#define GPIO_GET_BIT(PinId)     (PinId % 0x10)
//#define P(PinId)                GPIO_PIN_ADDR(GPIO_GET_PORT(PinId), GPIO_GET_BIT(PinId))
//#define GPIO_GET_IRQn(PinId)    GPIO_IRQn   //((IRQn_Type)((int8_t)GPIO0_IRQn + GPIO_GET_PORT(PinId)))


extern const uint8_t GPIO_TEST_PINS[][2];
extern const uint8_t GPIO_TEST_GRP_NUM;

// GPIO Driver Wrapper Functions
extern void SYS_ConfigMFP(uint8_t PinID, uint32_t PinFunction);
extern void GPIO_SetModeByPin(uint8_t PinID, GPIO_ModeDef Mode);
extern void GPIO_EnablePullupPathByPin(uint32_t PinID);
extern void GPIO_DisablePullupPathByPin(uint32_t PinID);
extern void GPIO_EnableIntByPin(uint32_t PinID, GPIO_IntAttrDef IntAttribs);
extern void GPIO_DisableIntByPin(uint32_t PinID);
extern void GPIO_EnableDebounceByPin(uint32_t PinID);
extern void GPIO_DisableDebounceByPin(uint32_t PinID);
extern void GPIO_EnableDoutMaskByPin(uint32_t PinID);
extern void GPIO_DisableDoutMaskByPin(uint32_t PinID);
extern void GPIO_SetOutValByPin(uint32_t PinID, bool PinVal);
extern bool GPIO_GetOutValByPin(uint32_t PinID);

// GPIO Test Cases
extern T_GPIO_TEST_RESULT GPIO_PushPullModeTestCase(uint8_t TargetPin, uint8_t AuxiliaryPin);
extern T_GPIO_TEST_RESULT GPIO_OpenDrainModeTestCase(uint8_t TargetPin, uint8_t AuxiliaryPin);
extern T_GPIO_TEST_RESULT GPIO_QuasiBidirectionalModeTestCase(uint8_t TargetPin, uint8_t AuxiliaryPin);
extern T_GPIO_TEST_RESULT GPIO_DebounceTestCase(uint8_t TargetPin, uint8_t AuxiliaryPin);
extern T_GPIO_TEST_RESULT GPIO_InterruptTestCase(uint8_t TargetPin, uint8_t AuxiliaryPin);

extern void GPIO_TestFunctionEnter(uint16_t TcIdx);

extern IRQn_Type GPIO_GetIRQn(uint8_t PinId);
#ifdef __cplusplus
}
#endif

#endif //__GPIO_COMMON_H__
