/**************************************************************************//**
 * @file     clktrim_common.c
 * @version  V1.0
 * $Date:    20/10/14 16:42 $
 * @brief    Common source file for clktrim test.
 *
 * @note
 * Copyright (C) 2020 Panchip Technology Corp. All rights reserved.
 *
 ******************************************************************************/
#include <ctype.h>
#include "pan271x.h"
#include "clktrim_common.h"

uint8_t stop_int_flag = 0,hw_trig_flag = 0;

void TRIM_TestModuleInit(void)
{
    // Enable Clock
	CLK_APB1PeriphClockCmd(CLK_APB1Periph_TRIM,ENABLE);
	NVIC_EnableIRQ(TRIM_IRQn);

	/* apbclk output 32k clk */
	SYS->SYS_CTRL |= SYS_CTRL_CLK_OUT_SEL_Msk;
	SYS_SET_MFP(P1,7, APB1_CLK);
	
	SYS_SET_MFP(P2,0, EXT_MEAS_CLK);
	GPIO_EnableDigitalPath(P2, BIT0);
}

void TRIM_IRQHandler(void)
{
	if(CLKMEAS_GetFlag(CLKMEAS) == CLKMEAS_MEASURE_FLAG_Msk)
	{
		SYS_TEST("measure done \n");
		CLKMEAS_ClearFlag(CLKMEAS);
	}
	stop_int_flag = 1;
}
