/****************************************************************************
 * @file     main.c
 * @version  V1.00
 * $Revision: 1 $
  * $Date: 16/02/ 10:37 $
 * @brief    ADC sample main file.
 *
 * @note
 * Copyright (C) 2025 Shanghai Panchip Microelectronics Co., Ltd.   All rights reserved.
 *
 ******************************************************************************/

#include "pan271x.h"
#include "adc_common.h"


/*---------------------------------------------------------------------------------------------------------*/
/* Define functions prototype                                                                              */
/*---------------------------------------------------------------------------------------------------------*/

void Clock_Init(void)
{
	PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_OTP_READ_MODE_SEL_Msk;
	PMU->SYS_CLK_CTRL &= ~(SYS_CLK_CTRL_OTP_CLK_HIGH_CYCLE_Msk | SYS_CLK_CTRL_OTP_CLK_LOW_CYCLE_Msk);
	PMU->SYS_CLK_CTRL |= ((0x1 << SYS_CLK_CTRL_OTP_CLK_HIGH_CYCLE_Pos) | (0x0 << SYS_CLK_CTRL_OTP_CLK_LOW_CYCLE_Pos));
	PMU->SYS_CLK_CTRL |= SYS_CLK_CTRL_OTP_SW_UP_CYCLE_EN_Msk;

	PMU->ANA_ANALDO |= ANA_ANALDO_EN_LDO_FSYN_AON_Msk;
    //MCU
	CLK_XthStartupConfig();
	PMU->XTH_CTRL |= XTH_CTRL_FSYNXO_BUFEN_AON_Msk;
    PMU->XTH_CTRL |= XTH_CTRL_FSYNXO_EN_AON_Msk;
	CLK_WaitClockReady(CLK_SYS_SRCSEL_XTH);

	CLK_HCLKConfig(0);

	CLK_SYSCLKConfig(CLK_DPLL_REF_CLKSEL_XTH,CLK_DPLL_OUT_48M); 
	CLK_RefClkSrcConfig(CLK_SYS_SRCSEL_DPLL_1);

	CLK_AHBPeriphClockCmd(CLK_AHBPeriph_APB1,ENABLE);
	CLK_APB1PeriphClockCmd(CLK_APB1Periph_ADC|CLK_APB1Periph_UART0,ENABLE);
}

static void Sys_Init(void)
{
    /* Unlock protected registers */
    SYS_UnlockReg();

    /* Init I/O Multi-function  */
	SYS_SET_MFP(P0, 5, UART0_TX);
	SYS_SET_MFP(P0, 6, UART0_RX);
	GPIO_EnableDigitalPath(P0, BIT6);

	UART_Init(UART0, 115200);

	SYS_SET_MFP(P1, 6, PWM_CH0);
    SYS_LockReg();
}

void platform_init()
{
    Clock_Init();
    Sys_Init();
}

void ADC_PrintSampleInfo()
{
    SYS_TEST("\n");
    SYS_TEST("+-----------------------------------------------------------------------+ \n");
    SYS_TEST("|                        PAN271x ADC Sample Code.                       | \n");
    SYS_TEST("+-----------------------------------------------------------------------+ \n");
    SYS_TEST("|    Press key to start specific testcase:                              | \n");
    SYS_TEST("|                                                                       | \n");
    SYS_TEST("|    Input '1'    Testcase 1: Convert Test.                             | \n");
    SYS_TEST("|    Input '2'    Testcase 2: ADC Interrupt Test.                       | \n");
    SYS_TEST("|    Input '3'    Testcase 3: Temperature Test Case.                    | \n");
    SYS_TEST("|    Input '4'    Testcase 4: ADC Pwm One Adc Channel Test.             | \n");
    SYS_TEST("|    Input '5'    Testcase 5: ADC Hardware timer trig Test.             | \n");
    SYS_TEST("+-----------------------------------------------------------------------+ \n");
}


void ADC_IoInit(void)
{
	P2->DINOFF |= ((0X1u << 0) << 24); //p20
}

int main(void)
{
    char input;
    platform_init();

    // Initialize ADC module before use
    if (!ADC_Init(ADC, false)) {
        SYS_TEST("Error: ADC init fail! Check if SoC hardware calibration data is successfully loaded!\n");
    }

	/* test mode init */
	ADC_IoInit();

    SYS_TEST("\nCPU @ %dHz\n", SystemCoreClock);

    ADC_PrintSampleInfo();

    input = getchar();
    while(input){
        SYS_TEST("\r\n");
        switch(input){
				case '1':ADC_TestFunctionEnter(0);break;
				case '2':ADC_TestFunctionEnter(1);break;
				case '3':ADC_TestFunctionEnter(2);break;
				case '4':ADC_TestFunctionEnter(3);break;
				case '5':ADC_TestFunctionEnter(4);break;
			  default:break;
        }
        ADC_PrintSampleInfo();
        input = getchar();
    }
}
