/********************************************************* * 
@file		:adc_convert_test.c 
@brief  	:adc convert function test
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/10/28
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/
#include "pan271x.h"
#include "adc_common.h"

/*
  * @brief     :adc Temperature Test
  * @retval    :0/1
*/
uint32_t ADC_TemperatureTest(void)
{
	uint16_t code_buf[ADC_CONV_CODE_TOTAL_CNT];

	P2->DINOFF &= ~((0X1 << 0) << 24); //close ext adc channel(must)

	ADC_IntEnable(ADC, ADC_CTL_EMPTY_INT_EN_Msk|ADC_CTL_OV_INT_EN_Msk
				|ADC_CTL_HALF_INT_EN_Msk|ADC_CTL_FULL_INT_EN_Msk|ADC_CTL_ADCIEN_Msk, DISABLE);
	ADC_HwTrigEnable(ADC, DISABLE);
	ADC_VrefVoltageSelect(ADC, ADC_VREF_VOL_SEL_VBAT);
	ADC_LoadWeightCfg();
	ADC_SetWeightRatio(ADC, weight_dif);
	ADC_SetSampleCount(ADC, 4);
	ADC_SetDiscardCount(ADC, 0x1);
	ADC_EnableAverage(ADC, ENABLE);
	ADC_ChannelSel(ADC, ADC_CHANNEL_SEL_TEMP);

    // Power on ADC
    ADC_PowerOn(ADC);

    // Delay a while to wait adc stable
    SYS_delay_10nop(50000);

	uint32_t cnt = 100;
	while(cnt--){
		while(ADC_IsBusy(ADC)){}
		ADC_StartConvert(ADC);
		while(!ADC_IsDataValid(ADC)){}
		code_buf[99-cnt] = ADC_GetConversionData(ADC);
	}

	for(cnt = 0;cnt < 100;cnt++){
		SYS_TEST("%d ",code_buf[cnt]);
		if(cnt % 10 == 9)
			SYS_TEST("\r\n");
	}

    // Power down ADC
    ADC_PowerDown(ADC);

	P2->DINOFF |= ((0X1 << 0) << 24); //open ext adc channel P20
    return 0;

}
