/********************************************************* * 
@file		:adc_default_value.c 
@brief  	:adc register default value check
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/10/28
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/

#include "pan271x.h"
#include "adc_common.h"

const uint32_t AdcDefaultValue[]=
{
    0x00000000,                    //ADC->DAT  
    0x00000000,                    //ADC->CTL
    0x00000000,                    //ADC->STATUS
    0x80001310,                    //ADC->CTL2
    0x4000C808,                    //ADC->ADC_WDR1
    0xCC024060,                    //ADC->ADC_WDR2
    0xF002C0C0,                    //ADC->ADC_WDR3
    0xA4058040,                    //ADC->ADC_WDR4
    0x80081020,                    //ADC->ADC_WDR5
    0x02000220,                    //ADC->ADC_TEMP
};


/*
  * @brief	   :adc register default value check
  * @retval    :0/1
*/
uint32_t ADC_RegisterDefaultCheck(void)
{
    uint8_t i = 0,different = 0;
	uint16_t register_size = sizeof(AdcDefaultValue) / sizeof(AdcDefaultValue[0]);
	
	for (i = 0; i < register_size; i++) {
		if (((__IO uint32_t *)&(ADC->ADC_DAT))[i] != AdcDefaultValue[i]){
			SYS_TEST("adc,adc addr offset:%x,expect:%08x,current:%08x \r\n",i*4,AdcDefaultValue[i],((__IO uint32_t *)(&ADC->ADC_DAT))[i]);
			different++;
		} 
	}
    if(!different){
       SYS_TEST("ADC default value check ok \r\n"); 
    }
    return 0;
}
