/********************************************************* * 
@file		:adc_convert_test.c 
@brief  	:adc convert function test
@author 	:zhongfeng
@version	:v1.0 
@date 		:19/10/28
Copyright (C) 2019 Panchip Technology Corp. All rights reserved. 
***********************************************************/
#include "pan271x.h"
#include "adc_common.h"

uint32_t ADC_ConvertTest(void)
{
    uint16_t code_buf[ADC_CONV_CODE_TOTAL_CNT];
    uint32_t result_code;
    float adc_data;
    char input;

    SYS_TEST("adc clk source select ahb/xth\n");
    CLK->APB1_CLK_CTRL0 |= APB1_CLK_CTRL0_ADC_CLK_SEL_Msk; //xth

	ADC_IntEnable(ADC, ADC_CTL_EMPTY_INT_EN_Msk|ADC_CTL_OV_INT_EN_Msk
				|ADC_CTL_HALF_INT_EN_Msk|ADC_CTL_FULL_INT_EN_Msk|ADC_CTL_ADCIEN_Msk, DISABLE);
	ADC_HwTrigEnable(ADC, DISABLE);
	ADC_VrefVoltageSelect(ADC, ADC_VREF_VOL_SEL_VBAT);
	ADC_LoadWeightCfg();
	ADC_SetWeightRatio(ADC, weight_dif);
	ADC_SetSampleCount(ADC, 7); // SAMPLE 128+2 times
	ADC_SetDiscardCount(ADC, 0x0); //discard 2 times
	ADC_EnableAverage(ADC, ENABLE);
	ADC_DecimalReadEnable(ADC, ENABLE);

	ADC_PowerOn(ADC);

	uint32_t cnt = 100;

	cnt = 100;
	while(cnt--){
		while(ADC_IsBusy(ADC)){}
		ADC_StartConvert(ADC);
		while(!ADC_IsDataValid(ADC)){}
		result_code = ADC_GetConversionData(ADC);
		code_buf[99-cnt] = result_code;
	}

	for(cnt = 0;cnt < 100;cnt++){
		adc_data = (float)code_buf[cnt]/16;
		SYS_TEST("%.2f ",adc_data);
		if(cnt % 10 == 9)
			SYS_TEST("\r\n");
	}

    // Power down ADC
    ADC_PowerDown(ADC);
    return 0;
}

